/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import com.sap.hdb.sl.lib.utils.CommandList;
import com.sap.hdb.sl.lib.utils.HdbUninstExecutable;
import com.sap.hdb.sl.lib.utils.HdbUninstOption;
import com.sap.hdb.sl.lib.utils.UninstallationParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HdbUninst
extends ExternalProcess {
    protected RunReason runReason = RunReason.UNINSTALL_CLIENT;
    protected HdbUninstExecutable hdbUninstExecutable = null;
    private Map<HdbUninstOption, String> options = new HashMap<HdbUninstOption, String>();
    private Map<HdbUninstOption, UninstallationParameter> uninstallationParameters = new HashMap<HdbUninstOption, UninstallationParameter>();
    private boolean foundErrorInOutput = false;

    protected HdbUninst(HdbUninstExecutable hdbUninstExecutable) {
        this.hdbUninstExecutable = hdbUninstExecutable;
    }

    public void addParameter(UninstallationParameter parameter) {
        HdbUninstOption option = parameter.getHdbUninstOption();
        String value = parameter.getValue();
        this.options.put(option, value);
        this.uninstallationParameters.put(option, parameter);
    }

    public void addParameters(List<UninstallationParameter> parameters) {
        for (UninstallationParameter parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public HdbUninstExecutable get() {
        return this.hdbUninstExecutable;
    }

    public void uninstallServer() {
        this.runReason = RunReason.UNINSTALL_SERVER;
        this.foundErrorInOutput = false;
        String[] commandLine = this.getCommandLineForUninstallServer().toArray(new String[0]);
        this.execute(commandLine);
        if (this.foundErrorInOutput) {
            this.throwException();
        }
    }

    public void uninstallClient() {
        this.runReason = RunReason.UNINSTALL_CLIENT;
        this.foundErrorInOutput = false;
        String[] commandLine = this.getCommandLineForUninstallClient().toArray(new String[0]);
        this.execute(commandLine);
        if (this.foundErrorInOutput) {
            this.throwException();
        }
    }

    @Override
    protected void handleStdoutStderr(String message) {
        String comparString = message.toLowerCase(Locale.ENGLISH);
        switch (this.runReason) {
            default: 
        }
        if (comparString.startsWith("err:") || comparString.contains("failed") || comparString.contains("wrong usage!") || comparString.contains("permission denied")) {
            this.foundErrorInOutput = true;
        }
    }

    public List<String> getCommandLineForUninstallServer() {
        List<HdbUninstOption> missingOptions = this.isOptionMissing(HdbUninstOption.SID);
        if (missingOptions.size() > 0) {
            throw new HdbException(missingOptions + " Missing option[s] to uninstall server software!");
        }
        CommandList commands = new CommandList();
        commands.add(this.hdbUninstExecutable.get().getAbsolutePath());
        commands.add(HdbUninstOption.BATCH.toString());
        commands.add(HdbUninstOption.IGNORE_NOT_EXISTING);
        commands.add(HdbUninstOption.KEEP_USER);
        for (Map.Entry<HdbUninstOption, String> option : this.options.entrySet()) {
            HdbUninstOption key = option.getKey();
            String value = option.getValue();
            commands.add(key.toString());
            commands.add(value);
        }
        return commands;
    }

    public List<String> getCommandLineForUninstallClient() {
        CommandList commands = new CommandList();
        commands.add(this.hdbUninstExecutable.get().getAbsolutePath());
        commands.add(HdbUninstOption.BATCH);
        commands.add(HdbUninstOption.IGNORE_NOT_EXISTING);
        for (Map.Entry<HdbUninstOption, String> option : this.options.entrySet()) {
            HdbUninstOption key = option.getKey();
            String value = option.getValue();
            commands.add(key.toString());
            commands.add(value);
        }
        return commands;
    }

    private List<HdbUninstOption> isOptionMissing(HdbUninstOption ... mandatoryOptions) {
        ArrayList<HdbUninstOption> missing = new ArrayList<HdbUninstOption>();
        for (HdbUninstOption mandatoryOption : mandatoryOptions) {
            if (this.options.containsKey((Object)mandatoryOption)) continue;
            missing.add(mandatoryOption);
        }
        return missing;
    }

    public UninstallationParameter getInstallationOption(HdbUninstOption option) {
        return this.uninstallationParameters.get((Object)option);
    }

    private void throwException() {
        throw new HdbException("An error occured during command execution. Please check logfile for further information. Current Logfiles: " + LogFactory.getLogWriterFiles().toString());
    }

    public static enum RunReason {
        UNINSTALL_CLIENT,
        UNINSTALL_SERVER;

    }
}

