/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;

public class HdbUpdReg
extends ExternalProcess {
    protected String hdbUpdRegExecutable = null;
    protected String delivery_unit = null;
    protected String system_user = null;
    protected String system_user_password = null;
    protected String parameters = null;

    public HdbUpdReg(String hdbUpdRegExecutable) {
        this.hdbUpdRegExecutable = hdbUpdRegExecutable;
    }

    public HdbUpdReg(CmdClazzParameterMap parameters) {
        this.hdbUpdRegExecutable = parameters.get(CmdClazzParameterName.HDBLCMEXE).getValue();
        this.delivery_unit = parameters.get(CmdClazzParameterName.ARCHIVES).getValue();
        this.system_user = "SYSTEM";
        this.system_user_password = parameters.get(CmdClazzParameterName.DATABASE_SYSTEM_USER_PASSWORD).getValue();
    }

    private String[] getPasswordsForStdinInXML() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Passwords><system_user_password><![CDATA[" + this.system_user_password + "]]></system_user_password>" + "</Passwords>";
        return new String[]{xml};
    }

    public void installDeliveryUnit() {
        String[] commandLine = new String[]{this.hdbUpdRegExecutable, "--batch", "--read_password_from_stdin=xml", "--delivery_unit=" + this.delivery_unit, "--system_user=" + this.system_user};
        this.execute(commandLine, this.getPasswordsForStdinInXML());
    }

    @Override
    protected void handleStdoutStderr(String message) {
        System.out.println(message);
    }
}

