/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.operating.system.ExternalProcess;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.User;
import com.sap.hdb.sl.lib.utils.HdbUserStoreExecutable;
import java.util.List;
import java.util.Locale;

public class HdbUserStore
extends ExternalProcess {
    private RunReason runReason = null;
    private HdbUserStoreExecutable hdbUserStoreExecutable = null;
    private boolean foundErrorInOutput = false;
    private String errorMessage = "";
    private static final String USER_SWITCH = "-u";

    public HdbUserStore(HdbUserStoreExecutable hdbUserStoreExecutable) {
        this.hdbUserStoreExecutable = hdbUserStoreExecutable;
    }

    public HdbUserStore() {
        HdbUserStoreExecutable hdbUserStoreExecutable;
        String path = this.findHdbuserstore();
        if (null == path) {
            throw new HdbException("Could not find hdbclient in environment!");
        }
        this.hdbUserStoreExecutable = hdbUserStoreExecutable = new HdbUserStoreExecutable(path);
    }

    public void createEntry(Key key, String connectString, User connectUser) {
        this.runReason = RunReason.SET;
        HdbUserStoreKey storeKey = new HdbUserStoreKey(key, connectString, connectUser);
        String[] commandLine = new String[]{this.getHdbUserStoreExecutable(), this.runReason.toString(), storeKey.getKey(), storeKey.getConnectString(), storeKey.getConnectUser(), storeKey.getConnectPassword()};
        this.execute(commandLine);
        if (this.foundErrorInOutput) {
            throw new HdbException("The following error occured during the creation of the hdbuserstore | " + this.errorMessage + " | The command line was: " + this.getCmdAsString());
        }
    }

    public void createEntry(OperatingSystemUser osUser, Key key, String connectString, User connectUser) {
        this.runReason = RunReason.SET;
        HdbUserStoreKey storeKey = new HdbUserStoreKey(key, connectString, connectUser);
        String osUserName = osUser.getName().get();
        String[] commandLine = new String[]{this.getHdbUserStoreExecutable(), USER_SWITCH, osUserName, this.runReason.toString(), storeKey.getKey(), storeKey.getConnectString(), storeKey.getConnectUser(), storeKey.getConnectPassword()};
        this.execute(commandLine);
        if (this.foundErrorInOutput) {
            throw new HdbException("The following error occured during the creation of the hdbuserstore | " + this.errorMessage + " | The command line was: " + this.getCmdAsString());
        }
    }

    public String getHdbUserStoreExecutable() {
        if (!this.hdbUserStoreExecutable.exists()) {
            throw new HdbException(this.hdbUserStoreExecutable + " Path or file is not a valid Hana client software path or a valid hdbuserstore executable");
        }
        String hdbuserstore = this.hdbUserStoreExecutable.toString();
        return hdbuserstore;
    }

    @Override
    protected void handleStdoutStderr(String message) {
        String tmpMsg = message.toUpperCase(Locale.ENGLISH);
        if (tmpMsg.contains("ERROR") || tmpMsg.contains("DOES NOT EXIST") || tmpMsg.contains("NO SUCH FILE OR DIRECTORY")) {
            this.foundErrorInOutput = true;
            this.errorMessage = message;
        }
        switch (this.runReason) {
            case EMPTY: 
            case LIST: {
                this.resltList.add(message);
                break;
            }
        }
    }

    public boolean doesKeyExist(Key key) {
        return this.doesKeyExist(null, key);
    }

    public boolean doesKeyExist(OperatingSystemUser osUser, Key key) {
        boolean exists = false;
        this.runReason = RunReason.LIST;
        String hdbuserstore = this.getHdbUserStoreExecutable();
        String osUserName = null;
        if (null != osUser) {
            osUserName = osUser.getName().get();
        }
        String[] commandLine = null;
        commandLine = null != osUser ? new String[]{hdbuserstore, USER_SWITCH, osUserName, this.runReason.toString(), key.toString()} : new String[]{hdbuserstore, this.runReason.toString(), key.toString()};
        this.execute(commandLine);
        if (this.foundErrorInOutput) {
            throw new HdbException("The following error occured during the creation of the hdbuserstore | " + this.errorMessage + " | The command line was: " + this.getCmdAsString());
        }
        List<String> result = this.getResult();
        for (String line : result) {
            String s = line.toUpperCase(Locale.ENGLISH);
            if (s.contains("NOT FOUND")) {
                exists = false;
                break;
            }
            if (!s.contains("KEY " + key.toString())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public void deleteKey(Key key) {
        this.deleteKey(null, key);
    }

    public void deleteKey(OperatingSystemUser osUser, Key key) {
        this.runReason = RunReason.DELETE;
        String osUserName = null;
        if (null != osUser) {
            osUserName = osUser.getName().get();
        }
        String[] commandLine = null;
        OsToolBox os = OsToolboxFactory.getToolbox();
        commandLine = null != osUser && os.onWindows() ? new String[]{this.getHdbUserStoreExecutable(), USER_SWITCH, osUserName, this.runReason.toString(), key.toString()} : (null != osUser && os.onUnix() ? new String[]{"su", "-c", "'" + this.getHdbUserStoreExecutable() + " " + this.runReason.toString() + " " + key.toString() + "'"} : new String[]{this.getHdbUserStoreExecutable(), this.runReason.toString(), key.toString()});
        this.execute(commandLine);
        if (this.foundErrorInOutput) {
            throw new HdbException("The following error occured during the creation of the hdbuserstore | " + this.errorMessage + " | The command line was: " + this.getCmdAsString());
        }
    }

    public boolean doesSupportTenantAwareSyntax() {
        this.runReason = RunReason.EMPTY;
        String[] commandLine = new String[]{this.getHdbUserStoreExecutable()};
        this.execute(commandLine);
        for (String line : this.resltList) {
            if (!line.contains("DATABASE")) continue;
            return true;
        }
        return false;
    }

    public String getConnString(Key key) {
        this.runReason = RunReason.LIST;
        String[] commandLine = new String[]{this.getHdbUserStoreExecutable(), this.runReason.toString(), key.toString()};
        String connString = "";
        String database = "";
        String env = "ENV : ";
        String db = "DATABASE: ";
        this.execute(commandLine);
        for (String line : this.resltList) {
            if (line.contains(env)) {
                connString = line.replace(env, "");
                connString = connString.trim();
                continue;
            }
            if (!line.contains(db)) continue;
            database = line.replace(db, "");
            database = database.trim();
        }
        if (database.length() > 0) {
            connString = connString + "@" + database;
        }
        return connString;
    }

    private String findHdbuserstore() {
        String[] commandLine = null;
        this.runReason = RunReason.EMPTY;
        OsToolBox os = OsToolboxFactory.getToolbox();
        commandLine = os.onWindows() ? new String[]{"where", "hdbuserstore"} : new String[]{"which", "hdbuserstore"};
        this.execute(commandLine);
        for (String line : this.resltList) {
            if (line.contains("Execute command:") || !line.contains("hdbuserstore")) continue;
            return line;
        }
        return null;
    }

    private class HdbUserStoreKey {
        private String connectionString = null;
        private String connectUserName = null;
        private String connectUserPassword = null;
        private String key = null;

        public HdbUserStoreKey(Key key, String connectString, User connectUser) {
            this.key = key.toString();
            this.connectionString = connectString;
            this.connectUserName = connectUser.getName().get();
            this.connectUserPassword = connectUser.getPassword() != null ? connectUser.getPassword().get() : "\"\"";
        }

        public String getKey() {
            return this.key;
        }

        public String getConnectString() {
            return this.connectionString;
        }

        public String getConnectUser() {
            return this.connectUserName;
        }

        public String getConnectPassword() {
            return this.connectUserPassword;
        }
    }

    private static enum RunReason {
        SET,
        LIST,
        DELETE,
        EMPTY;

    }

    public static enum Key {
        DEFAULT,
        DEFAULT_TARGET,
        GENERIC,
        HDI_SUPPORT,
        HDI_SUPPORT_TARGET;

        private String name;

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            if (null == this.name) {
                return super.toString();
            }
            return this.name;
        }
    }
}

