/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.OsToolBox;
import com.sap.hdb.sl.lib.operating.system.OsToolboxFactory;
import java.io.File;

public class HdbUserStoreExecutable {
    private File hdbUserStore = null;
    private boolean exists = false;

    protected HdbUserStoreExecutable(String clientSoftwarePath) {
        File path;
        String hdbuserstore = "hdbuserstore";
        OsToolBox os = OsToolboxFactory.getToolbox();
        if (os.onWindows()) {
            hdbuserstore = hdbuserstore + ".exe";
        }
        if ((path = new File(clientSoftwarePath)).exists() && path.isDirectory()) {
            this.hdbUserStore = new File(path, hdbuserstore);
            this.exists = true;
        } else if (path.exists() && path.isFile() && hdbuserstore.equalsIgnoreCase(path.getName())) {
            this.hdbUserStore = path;
            this.exists = true;
        } else {
            this.hdbUserStore = path;
            this.exists = false;
            LogFactory.writeLogEntry(this.getClass(), path + " Path or file is not a valid Hana client software path or a valid hdbuserstore executable");
        }
    }

    public File get() {
        return this.hdbUserStore;
    }

    public String toString() {
        return this.hdbUserStore.getAbsolutePath();
    }

    public boolean exists() {
        return this.exists;
    }
}

