/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.utils.HdbUserStore;
import com.sap.hdb.sl.lib.utils.HdbUserStoreExecutable;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterImpl;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import java.util.Locale;

public class HdbUserStoreFactory {
    public static HdbUserStore getUserStore(CmdClazzParameterMap parameters) {
        String clientSoftwarePath;
        if (parameters.containsKey(CmdClazzParameterName.CLIENT_SOFTWARE_PATH)) {
            clientSoftwarePath = parameters.get(CmdClazzParameterName.CLIENT_SOFTWARE_PATH).getValue();
        } else {
            HdbUserStore userstore = new HdbUserStore();
            clientSoftwarePath = userstore.getHdbUserStoreExecutable();
            parameters.put(CmdClazzParameterName.CLIENT_SOFTWARE_PATH, new CmdClazzParameterImpl(clientSoftwarePath));
        }
        HdbUserStoreExecutable exe = new HdbUserStoreExecutable(clientSoftwarePath);
        return new HdbUserStore(exe);
    }

    public static HdbUserStore getUserStore(String clientSoftwarePath) {
        HdbUserStoreExecutable exe = new HdbUserStoreExecutable(clientSoftwarePath);
        return new HdbUserStore(exe);
    }

    public static HdbUserStore.Key getKey(CmdClazzParameterMap parameters) {
        String keyValue = parameters.get(CmdClazzParameterName.USERSTORE_KEY_NAME).getValue();
        HdbUserStore.Key key = HdbUserStore.Key.valueOf(keyValue.toUpperCase(Locale.ENGLISH));
        return key;
    }
}

