/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfOSProcess;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.InstanceVersionInfo;
import com.sap.hdb.sl.lib.sapcontrol.OSProcess;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.sapcontrol.STATECOLOR;
import com.sap.hdb.sl.lib.sapcontrol.StartStopOption;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;

public class SAPControlHelper {
    private String host;
    private int port;
    private String username;

    private void setValues(URL wsdlUrl, String userName, String userPassword) {
        this.host = wsdlUrl.getHost();
        this.port = wsdlUrl.getPort() / 100 - 500;
        this.username = userName;
    }

    public SAPControlPortType getPort(URL wsdlUrl, String userName, String userPassword) {
        this.setValues(wsdlUrl, userName, userPassword);
        Service service = Service.create((URL)wsdlUrl, (QName)new QName("urn:SAPControl", "SAPControl"));
        SAPControlPortType port = (SAPControlPortType)service.getPort(SAPControlPortType.class);
        BindingProvider provider = (BindingProvider)port;
        Map requestContext = provider.getRequestContext();
        requestContext.put("javax.xml.ws.security.auth.username", userName);
        requestContext.put("javax.xml.ws.security.auth.password", userPassword);
        return port;
    }

    public String getSapcontrolCall() {
        if (this.host == null) {
            return "sapcontrol -nr <instance_no> -host <host> -user <admin_name> <password>";
        }
        return "sapcontrol -nr " + this.port + " -host " + this.host + " -user " + this.username + " <password>";
    }

    public boolean onWindows(SAPControlPortType port) {
        String osPlatform = port.parameterValue("OS_PLATFORM");
        if (osPlatform == null) {
            LogFactory.writeLogEntry(this.getClass(), "OS platform returned from SAPControl is null. Assuming Linux.");
            return false;
        }
        return osPlatform.toUpperCase(Locale.ENGLISH).contains("NT") || osPlatform.toUpperCase(Locale.ENGLISH).contains("WINDOWS");
    }

    public String getVersion(SAPControlPortType port) {
        String version = "UNKNOWN";
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method: " + this.getSapcontrolCall() + " -function GetVersionInfo");
        List<InstanceVersionInfo> info = port.getVersionInfo().getItem();
        if (!info.isEmpty()) {
            version = (String)info.get(0).getVersionInfo().getValue();
        }
        return version;
    }

    public String getInstanceDirectory(SAPControlPortType port) {
        String instanceDir = port.parameterValue("DIR_INSTANCE");
        if (instanceDir != null && !instanceDir.isEmpty()) {
            LogFactory.writeLogEntry(this.getClass(), "Instance Directory from parameter: " + instanceDir);
            return instanceDir;
        }
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method: " + this.getSapcontrolCall() + " -function GetEnvironment");
        ArrayOfString environment = port.getEnvironment();
        for (String process : environment.getItem()) {
            if (!process.startsWith("DIR_INSTANCE")) continue;
            String dir = process.substring(13);
            LogFactory.writeLogEntry(this.getClass(), "Instance Directory from environment: " + dir);
            return dir;
        }
        return null;
    }

    public void startSystem(SAPControlPortType port, long startupTimeout) throws TimeoutException, InterruptedException {
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method: " + this.getSapcontrolCall() + " -function StartSystem");
        port.startSystem(StartStopOption.SAP_CONTROL_ALL_INSTANCES, null, 300, null);
        boolean stopped = true;
        long startTime = System.currentTimeMillis();
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method: " + this.getSapcontrolCall() + " -function GetProcessList");
        block0: while (stopped) {
            if (System.currentTimeMillis() - startTime > startupTimeout) {
                String message = "A timeout occurred while starting the database instance. Please check the database log and start the database manually before continuing.";
                throw new TimeoutException(message);
            }
            ArrayOfOSProcess processList = port.getProcessList();
            for (OSProcess process : processList.getItem()) {
                if (process.getDispstatus() == STATECOLOR.SAP_CONTROL_GREEN) {
                    stopped = false;
                    continue;
                }
                stopped = true;
                Thread.sleep(1000L);
                continue block0;
            }
        }
    }

    public void stopSystem(SAPControlPortType port, long shutdownTimeout) throws TimeoutException, InterruptedException {
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method: " + this.getSapcontrolCall() + " -function StopSystem");
        port.stopSystem(StartStopOption.SAP_CONTROL_ALL_INSTANCES, null, 0, 0);
        boolean stopped = false;
        ArrayOfOSProcess processList = null;
        long startTime = System.currentTimeMillis();
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method: " + this.getSapcontrolCall() + " -function GetProcessList");
        block0: while (!stopped) {
            if (System.currentTimeMillis() - startTime > shutdownTimeout) {
                String message = "A timeout occurred while shutting down the database instance.";
                throw new TimeoutException(message);
            }
            processList = port.getProcessList();
            for (OSProcess process : processList.getItem()) {
                if (process.getDispstatus() == STATECOLOR.SAP_CONTROL_GRAY || process.getDispstatus() == STATECOLOR.SAP_CONTROL_RED) {
                    stopped = true;
                    continue;
                }
                stopped = false;
                Thread.sleep(1000L);
                continue block0;
            }
        }
    }
}

