/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.InstallationPath;
import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.InstanceGroup;
import com.sap.hdb.sl.lib.instance.InstanceNumber;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.utils.HdbInst;
import com.sap.hdb.sl.lib.utils.HdbInstExecutable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SystemInformation
extends HdbInst {
    private List<InstanceGroup> instanceGroups = null;
    private List<InstanceNumber> usedInstanceNumbers = null;
    private InstanceNumber nextFreeInstanceNumber = null;
    private InstanceGroup currentInstanceGroup = null;

    public SystemInformation(HdbInstExecutable hdbInstExecutable) {
        super(hdbInstExecutable);
    }

    public InstanceNumber getInstanceNumberForUse() {
        if (null == this.nextFreeInstanceNumber) {
            this.listSystems();
        }
        return this.nextFreeInstanceNumber;
    }

    public List<InstanceNumber> getInstanceNumbersInUse() {
        if (null == this.usedInstanceNumbers) {
            this.listSystems();
        }
        return this.usedInstanceNumbers;
    }

    @Override
    protected void handleStdoutStderr(String message) {
        String line = message.trim();
        if (this.lineContainsDescription(line)) {
            this.createNewInstanceGroup(line);
        } else if (this.currentInstanceGroup != null) {
            if (line.length() > 0) {
                this.addInstanceToGroup(line);
            } else {
                this.addInstanceGroup(this.currentInstanceGroup);
                this.currentInstanceGroup = null;
            }
        } else if (line.toUpperCase(Locale.ENGLISH).startsWith("ALREADY USED INSTANCE NUMBERS:")) {
            String subLine = line.substring(line.indexOf(":") + 1);
            if (subLine.contains(",")) {
                String[] numbers;
                for (String number : numbers = subLine.split(",")) {
                    this.addInstanceNumberInUse(new InstanceNumber(number));
                }
            } else {
                this.addInstanceNumberInUse(new InstanceNumber(subLine));
            }
        } else if (line.toUpperCase(Locale.ENGLISH).startsWith("NEXT FREE INSTANCE NUMBER:")) {
            String number = line.substring(line.indexOf(":") + 1);
            this.nextFreeInstanceNumber = new InstanceNumber(number);
        }
    }

    private void addInstanceToGroup(String line) {
        int firstBlank = line.indexOf(" ");
        int versionInLine = line.indexOf("version:");
        Instance.Type instanceType = Instance.Type.valueOf(line.substring(0, firstBlank));
        Instance instance = null;
        if (Instance.Type.HDB.equals((Object)instanceType)) {
            String instanceNumber = line.substring(firstBlank, versionInLine).trim();
            String version = line.substring(versionInLine + "version:".length(), line.indexOf("hosts:"));
            String hostname = line.substring(line.lastIndexOf(" "));
            instance = InstanceFactory.getInstance(instanceType, new InstanceNumber(instanceNumber), new HdbVersion(version), new Hostname(hostname));
        } else {
            String instanceNumber = line.substring(firstBlank);
            instance = InstanceFactory.getInstance(instanceType, new InstanceNumber(instanceNumber));
        }
        this.currentInstanceGroup.addInstance(instance);
    }

    private void createNewInstanceGroup(String line) {
        String sid = line.substring(0, 3);
        String path = line.substring(3, line.lastIndexOf(" ")).trim();
        String description = line.substring(line.lastIndexOf(" ")).trim();
        try {
            this.currentInstanceGroup = new InstanceGroup(new Sid(sid), new InstallationPath(path), InstanceGroup.Description.valueOf(description));
        }
        catch (Exception e) {
            throw new HdbException(e.getMessage() + " error during parsing of line: " + line);
        }
    }

    private void addInstanceGroup(InstanceGroup newInstanceGroup) {
        if (null == this.instanceGroups) {
            this.instanceGroups = new ArrayList<InstanceGroup>();
        }
        this.instanceGroups.add(newInstanceGroup);
    }

    private void addInstanceNumberInUse(InstanceNumber number) {
        if (null == this.usedInstanceNumbers) {
            this.usedInstanceNumbers = new ArrayList<InstanceNumber>();
        }
        this.usedInstanceNumbers.add(number);
    }

    public List<InstanceGroup> getInstanceGroups() {
        if (null == this.instanceGroups) {
            this.listSystems();
        }
        return this.instanceGroups;
    }

    public InstanceGroup getInstanceGroup(Sid sid) {
        InstanceGroup group = null;
        List<InstanceGroup> groups = this.getInstanceGroups();
        for (InstanceGroup g : groups) {
            if (!sid.equals(g.getSid())) continue;
            group = g;
            break;
        }
        if (null == group) {
            throw new HdbException(sid + " no such system!");
        }
        return group;
    }

    public Instance getInstance(Instance.Type type, Sid sid) {
        Instance instance = null;
        List<InstanceGroup> groups = this.getInstanceGroups();
        for (InstanceGroup group : groups) {
            if (!group.getSid().equals(sid) || !group.containsInstance(type)) continue;
            instance = group.getInstance(type);
            break;
        }
        if (null == instance) {
            throw new HdbException(sid + " No instance of type " + type.toString() + " exists for that sid!");
        }
        return instance;
    }

    public boolean doesInstanceGroupExist(Sid sid) {
        boolean exists = false;
        List<InstanceGroup> groups = this.getInstanceGroups();
        for (InstanceGroup group : groups) {
            if (!group.getSid().equals(sid)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public boolean doesInstanceExist(Instance.Type type) {
        boolean exists = false;
        List<InstanceGroup> groups = this.getInstanceGroups();
        for (InstanceGroup group : groups) {
            if (!group.containsInstance(type)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public boolean doesInstanceExist(Instance.Type type, Sid sid) {
        boolean exists = false;
        List<InstanceGroup> groups = this.getInstanceGroups();
        for (InstanceGroup group : groups) {
            if (!group.getSid().equals(sid) || !group.containsInstance(type)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public List<Instance> getInstances(Instance.Type type) {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        List<InstanceGroup> groups = this.getInstanceGroups();
        for (InstanceGroup group : groups) {
            if (!group.containsInstance(type)) continue;
            Instance instance = group.getInstance(type);
            instances.add(instance);
        }
        return instances;
    }

    public boolean isInstanceNumberFree(InstanceNumber instanceNumber) {
        boolean isFree = true;
        for (InstanceNumber tmpNumber : this.getInstanceNumbersInUse()) {
            if (!tmpNumber.equals(instanceNumber)) continue;
            isFree = false;
            break;
        }
        return isFree;
    }

    private boolean lineContainsDescription(String lineParam) {
        boolean containsDescription = false;
        String line = lineParam.toUpperCase(Locale.ENGLISH);
        for (InstanceGroup.Description description : InstanceGroup.Description.values()) {
            String upperDescr = description.toString().toUpperCase(Locale.ENGLISH);
            if (!line.contains(upperDescr)) continue;
            containsDescription = true;
            break;
        }
        return containsDescription;
    }
}

