/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.FileParameter;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractUpdateTablePlacement
extends BatchExecutionBase {
    protected JdbcDriver jdbcDriver = null;
    protected DatabaseSystemUser systemUser = null;
    protected Database database = null;
    protected JdbcConnection connection = null;
    protected File parameterFile = null;
    protected DatabaseUser connectUser = null;
    private final boolean dropStatementsMayFail;

    public AbstractUpdateTablePlacement(boolean dropStatementsMayFail) {
        this.dropStatementsMayFail = dropStatementsMayFail;
    }

    public AbstractUpdateTablePlacement() {
        this(false);
    }

    protected abstract List<String> getStatements(List<String> var1);

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        FileParameter fileParameter = (FileParameter)parameters.get(CmdClazzParameterName.DATABASE_REORG_PARAMETER_FILE);
        this.parameterFile = fileParameter.getFile();
    }

    protected List<String> readFromFile() {
        ArrayList<String> content = new ArrayList<String>();
        try {
            BufferedReader bR = new BufferedReader(new FileReader(this.parameterFile));
            String line = bR.readLine();
            while (line != null) {
                content.add(line.trim());
                line = bR.readLine();
            }
            bR.close();
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
        return content;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.connectUser);
        List<String> content = this.readFromFile();
        for (String statement : this.getStatements(content)) {
            boolean allowExceptions = false;
            if (this.dropStatementsMayFail && statement.trim().toUpperCase(Locale.ENGLISH).startsWith("DROP ")) {
                allowExceptions = true;
            }
            this.connection.executeSQLCommand(statement, allowExceptions);
        }
        LogFactory.writeLogEntry(this.getClass(), "Table _SYS_RT.TABLE_PLACEMENT was updated successfully.");
    }
}

