/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Privilege;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class AddAflRolesToUser
implements CmdClazz {
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected AddAflRolesToUser() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        DatabaseUserRoleName.Role[] aflRoleNames;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        for (DatabaseUserRoleName.Role roleName : aflRoleNames = new DatabaseUserRoleName.Role[]{DatabaseUserRoleName.Role.AFL__SYS_AFL_ERPA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_LCAPPS_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_AFLPAL_EXECUTE}) {
            DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(roleName);
            if (role.exists(this.connection, this.systemUser)) {
                boolean granted = PrivilegesUtils.checkRole(this.connection, role.getName().get(), this.sqlUser.getName().get());
                if (granted) continue;
                role.grantTo(this.connection, this.systemUser, this.sqlUser);
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), role.getName() + ", Cannot add AFL Role to user because it does not exist!");
        }
        String[] optionalGrants = new String[]{"GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYSTEM.AFL_WRAPPER_GENERATOR TO " + this.sqlUser.getName().get(), "GRANT " + (Object)((Object)Privilege.EXECUTE) + " ON SYSTEM.AFL_WRAPPER_ERASER TO " + this.sqlUser.getName().get()};
        this.executeOptionalStatements(optionalGrants, this.connection, this.systemUser);
    }

    private void executeOptionalStatements(String[] statements, JdbcConnection connection, DatabaseUser systemUser) {
        connection.setConnectUser(systemUser);
        for (String statement : statements) {
            this.executeOptionalStatement(statement, connection, systemUser);
        }
    }

    private boolean executeOptionalStatement(String statement, JdbcConnection connection, DatabaseUser systemUser) {
        try {
            connection.executeSQLCommand(statement);
            return true;
        }
        catch (HdbException e) {
            if (connection.getErrorCode() == 397) {
                LogFactory.writeLogEntry(this.getClass(), "Unable to execute optional statement '" + statement + "': Object doesn't exist.");
            } else {
                LogFactory.writeLogEntry(this.getClass(), "Unable to execute optional statement '" + statement + "': " + e.getMessage());
            }
            return false;
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

