/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.du.DU;
import com.sap.hdb.sl.lib.du.DUReaderDB;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.role.PrivilegeObject;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.List;

public class AddPrivilegesForEPMObjects
implements CmdClazz {
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    static String EPMMDS = "EPMMDS";
    static String _SYS_EPM = "_SYS_EPM";
    static String MDC_CREATE_METADATA = "MDC_CREATE_METADATA";
    static String MDC_UPDATE_METADATA = "MDC_UPDATE_METADATA";
    static String MDC_DELETE_METADATA = "MDC_DELETE_METADATA";
    static String MDC_DELETE_METADATAGROUP = "MDC_DELETE_METADATAGROUP";
    static String MDS_METADATA_DOCUMENTS = "MDS_METADATA_DOCUMENTS";
    static String EXECUTE = "EXECUTE";
    static String SELECT = "SELECT";

    protected AddPrivilegesForEPMObjects() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        block8: {
            String[] procedures;
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.systemUser);
            this.connection.setLogging(true);
            List<DU> plugins = DUReaderDB.listPlugins(this.connection);
            boolean pluginInstalled = false;
            for (DU plugin : plugins) {
                String name = plugin.getDELIVERY_UNIT();
                if (!name.equalsIgnoreCase(EPMMDS)) continue;
                pluginInstalled = true;
                break;
            }
            if (!pluginInstalled) {
                LogFactory.writeLogEntry(this.getClass(), "Plugin " + EPMMDS + " not installed. Nothing to do.");
                return;
            }
            for (String procedure : procedures = new String[]{MDC_CREATE_METADATA, MDC_UPDATE_METADATA, MDC_DELETE_METADATA, MDC_DELETE_METADATAGROUP}) {
                PrivilegeObject priv = new PrivilegeObject(new String[]{_SYS_EPM, procedure, EXECUTE});
                boolean granted = PrivilegesUtils.checkObjectPrivilege(this.connection, priv, this.sqlUser.getName().get());
                if (granted) continue;
                try {
                    this.connection.executeSQLCommand("GRANT " + EXECUTE + " ON " + _SYS_EPM + "." + procedure + " TO " + this.sqlUser.getName().get());
                }
                catch (HdbException e) {
                    int errorCode = this.connection.getErrorCode();
                    if (errorCode == 397) continue;
                    throw e;
                }
            }
            PrivilegeObject priv = new PrivilegeObject(new String[]{_SYS_EPM, MDS_METADATA_DOCUMENTS, SELECT});
            boolean granted = PrivilegesUtils.checkObjectPrivilege(this.connection, priv, this.sqlUser.getName().get());
            if (!granted) {
                try {
                    this.connection.executeSQLCommand("GRANT " + SELECT + " ON " + _SYS_EPM + "." + MDS_METADATA_DOCUMENTS + " TO " + this.sqlUser.getName().get());
                }
                catch (HdbException e) {
                    int errorCode = this.connection.getErrorCode();
                    if (errorCode == 397) break block8;
                    throw e;
                }
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

