/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.HdbConnection;
import com.sap.hdb.sl.lib.connection.sql.HdbsqlConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Privilege;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseHdbsqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class AddPrivilegesToSysRepo
implements CmdClazz {
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser = null;
    private DatabaseSqlUser sysRepoUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private ResultFileWriter resultFileWriter;

    protected AddPrivilegesToSysRepo() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sysRepoUser = DatabaseSqlUserFactory.getUser(new DatabaseSqlUserName("_SYS_REPO"));
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
    }

    @Override
    public void execute() {
        DatabaseUserRoleName.Role[] aflRoleNames;
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        if (this.connection.getDbVersion() >= 4) {
            LogFactory.writeLogEntry(AddPrivilegesToSysRepo.class, "HANA 4 does not have schema _SYS_REPO. Skip this class...");
            return;
        }
        for (DatabaseUserRoleName.Role roleName : aflRoleNames = new DatabaseUserRoleName.Role[]{DatabaseUserRoleName.Role.ABAP_SYS_REPO, DatabaseUserRoleName.Role.AFL__SYS_AFL_AFLBFL_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_AFLPAL_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_ERPA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_POSDM_AREA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_SOP_AREA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_UDFCORE_AREA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_LCAPPS_EXECUTE}) {
            DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(roleName);
            if (role.exists(this.connection, this.systemUser)) {
                boolean granted = PrivilegesUtils.checkRole(this.connection, role.getName().get(), this.sysRepoUser.getName().get());
                if (granted) continue;
                role.grantTo(this.connection, this.systemUser, this.sysRepoUser);
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), role.getName() + ", Cannot add AFL Role to user because it does not exist!");
        }
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        HdbConnection slConnection = null;
        if (this.sqlUser.useJdbc()) {
            slConnection = this.connection;
            slConnection.setConnectUser(this.sqlUser);
        } else {
            slConnection = new HdbsqlConnection();
            DatabaseHdbsqlUser hdbSqlUser = (DatabaseHdbsqlUser)this.sqlUser;
            slConnection.setConnectUser(hdbSqlUser);
        }
        slConnection.setConnectUser(this.sqlUser);
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.isGrantableOnSchema()) continue;
            try {
                slConnection.executeSQLCommand("GRANT " + privilege.toString() + " ON SCHEMA " + this.sqlUser.getName().get() + " TO " + this.sysRepoUser.getName().get() + " WITH GRANT OPTION");
            }
            catch (HdbException e) {
                int errorCode = slConnection.getErrorCode();
                if (errorCode == 334 || errorCode == 3841) continue;
                throw e;
            }
        }
        this.resultFileWriter.append("true");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

