/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class AddSqlPrivilegesToAbapDatabaseRoles
implements CmdClazz {
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected AddSqlPrivilegesToAbapDatabaseRoles() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        DatabaseUserRole role;
        MissingPrivileges missing;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if ((missing = (role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.ABAP_READ)).checkPrivileges(this.connection, this.systemUser, this.sqlUser)).hasMissing()) {
            role.addSqlPrivileges(this.connection, this.systemUser, this.sqlUser);
        }
        if ((missing = (role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.ABAP_SYS_REPO)).checkPrivileges(this.connection, this.systemUser, this.sqlUser)).hasMissing()) {
            role.addSqlPrivileges(this.connection, this.systemUser, this.sqlUser);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

