/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseAudit;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AuditPolicyConfiguration
implements CmdClazz {
    private Database database;
    private DatabaseUser sqlUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private ResultFileWriter resultFileWriter;
    private DatabaseAudit dbAudit;
    private String action;
    private String parameterFilePath = null;
    private File parameterFile = null;
    private String sqlContent = null;
    private static String LIST_AUDIT_POLICIES = "LIST_AUDIT_POLICIES";
    private static String LIST_S4HANA_AUDIT_POLICIES = "LIST_S4HANA_AUDIT_POLICIES";
    private static String SET_AUDIT_POLICIES = "SET_AUDIT_POLICIES";
    private static String ENABLE_AUDITING = "ENABLE_AUDITING";
    private static String DISABLE_AUDITING = "DISABLE_AUDITING";
    private static String IS_AUDITING_ENABLED = "IS_AUDITING_ENABLED";

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.action = parameters.get(CmdClazzParameterName.AUDIT_ACTION).getValue();
        if (this.action.equals(SET_AUDIT_POLICIES)) {
            if (parameters.containsKey(CmdClazzParameterName.AUDIT_POLICY_FILE)) {
                this.parameterFilePath = parameters.get(CmdClazzParameterName.AUDIT_POLICY_FILE).getValue();
                this.sqlContent = this.readFromFileToString(this.parameterFilePath);
            } else {
                this.sqlContent = this.getScriptFromJar();
            }
        }
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.sqlUser);
        }
        this.dbAudit = new DatabaseAudit(this.connection, this.sqlUser);
        LogFactory.writeLogEntry(this.getClass(), "Audit Configuration action:  " + this.action);
        if (this.action.equals(IS_AUDITING_ENABLED)) {
            this.resultFileWriter.append(Boolean.toString(this.dbAudit.isAuditingOn()));
        } else if (this.action.equals(ENABLE_AUDITING)) {
            this.resultFileWriter.append(Boolean.toString(this.dbAudit.setAuditStateOn(this.connection, this.sqlUser)));
        } else if (this.action.equals(DISABLE_AUDITING)) {
            this.resultFileWriter.append(Boolean.toString(this.dbAudit.setAuditStateOff(this.connection, this.sqlUser)));
        } else if (this.action.equals(SET_AUDIT_POLICIES)) {
            this.dbAudit.setAuditPolicies(this.connection, this.getAuditSQL());
        } else {
            LogFactory.writeLogEntry(this.getClass(), "Unknown Audit Configuration action:  " + this.action);
        }
    }

    private String getAuditSQL() {
        return this.sqlContent;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    protected String readFromFileToString(String path) {
        try {
            String sCurrentLine;
            StringBuilder contentBuilder = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(path));
            while ((sCurrentLine = br.readLine()) != null) {
                contentBuilder.append(sCurrentLine).append("\n");
            }
            br.close();
            return contentBuilder.toString();
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
    }

    private String getScriptFromJar() {
        String script = "/com/sap/hdb/sl/lib/utils/scripts/create_S4_audit_policies.sql";
        String scriptContent = null;
        try {
            InputStream in = this.getClass().getResourceAsStream(script);
            if (in != null) {
                String line;
                StringBuilder cb = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                while ((line = br.readLine()) != null) {
                    cb.append(line).append("\n");
                }
                in.close();
                scriptContent = cb.toString();
            }
        }
        catch (Exception e) {
            System.out.println(script + " not found. Returning null.");
            e.printStackTrace();
        }
        return scriptContent;
    }
}

