/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.DatabaseSystemUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.BackupArchive;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.ws.Holder;

public class BackupArchives
implements CmdClazz {
    private ResultFileWriter resultWriter;
    private Database database;
    private DatabaseSystemUser systemUser;
    private DatabaseSystemUser systemDatabaseSystemUser;
    private OperatingSystemUser osUser;
    private SAPControlWsdlUrl wsdlUrl;
    private JdbcDriver jdbcDriver;
    private String backupLocation;
    private String traceLocation;
    private SAPControlHelper helper = new SAPControlHelper();
    private String archive;
    private String action;
    private String target;
    private int parallelJobs = 10;
    private String lastError = new String("No errors found.");
    private Sid tenantSid;
    private DatabaseSystemUserPassword systemUserPassword;
    private String PATH_SEPARATOR = new String(":");
    private Properties insertStatus = new Properties();

    protected BackupArchives() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.tenantSid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
        if (parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
            this.systemDatabaseSystemUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        }
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.systemUserPassword = this.systemUser.getPassword();
        this.jdbcDriver = new JdbcDriver(parameters);
        this.archive = parameters.get(CmdClazzParameterName.BACKUP_ARCHIVE_NAME).getValue();
        this.action = parameters.get(CmdClazzParameterName.BACKUP_ARCHIVE_ACTION).getValue();
        if (parameters.containsKey(CmdClazzParameterName.BACKUP_ARCHIVE_TARGET)) {
            this.target = parameters.get(CmdClazzParameterName.BACKUP_ARCHIVE_TARGET).getValue();
        }
        if (parameters.containsKey(CmdClazzParameterName.PARALLEL_JOBS)) {
            this.parallelJobs = new Integer(parameters.get(CmdClazzParameterName.PARALLEL_JOBS).getValue());
        }
        this.osUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
        this.wsdlUrl = new SAPControlWsdlUrl(parameters);
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("win") == 0) {
            this.PATH_SEPARATOR = ";";
        }
    }

    public boolean unsarBackup(SAPControlPortType port) {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setConnectUser(connectUser);
        if (connection.isMultiDB()) {
            connectUser = this.systemDatabaseSystemUser;
            this.database.setSid(new Sid("SYSTEMDB"));
            connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        String location = this.target;
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (location == null) {
            DatabaseConfiguration configuration = new DatabaseConfiguration(connection, connectUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
            DatabaseConfigurationSection persistenceSection = configuration.getSection("persistence");
            location = persistenceSection.getParameterValue("basepath_databackup");
            if (location == null) {
                throw new HdbException("Parameter '" + DatabaseConfiguration.ConfigFileName.GLOBAL_INI.toString() + " -> " + "persistence" + " -> basepath_databackup' is not set.");
            }
            LogFactory.writeLogEntry(this.getClass(), "Default database backup location: " + location);
            if (location.contains("$(DIR_INSTANCE)")) {
                LogFactory.writeLogEntry(this.getClass(), "Instance directory: " + instanceDir);
                if (instanceDir != null) {
                    location = location.replaceAll(Pattern.quote("$(DIR_INSTANCE)"), instanceDir.replaceAll(Pattern.quote("\\"), "\\\\\\\\"));
                    LogFactory.writeLogEntry(this.getClass(), "Processed database backup location: " + location);
                }
            }
            if (this.list(port, (location = location.replaceAll(Pattern.quote("\\"), "/")) + "/DB_" + this.tenantSid.getValue())) {
                location = location + "/DB_" + this.tenantSid.getValue();
            }
            LogFactory.writeLogEntry(this.getClass(), "Calculated database backup to location: " + location);
        }
        this.backupLocation = location;
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = instanceDir + "/exe/SAPCAR -xvf " + this.archive + " -R " + location;
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "BackupArchives_EXTRACT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Backup extraction failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup archive extracted.");
        return true;
    }

    public boolean unzipBackup(SAPControlPortType port) {
        DatabaseConfiguration configuration;
        DatabaseConfigurationSection persistenceSection;
        String location;
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setConnectUser(connectUser);
        if (connection.isMultiDB()) {
            connectUser = this.systemDatabaseSystemUser;
            this.database.setSid(new Sid("SYSTEMDB"));
            connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if ((location = (persistenceSection = (configuration = new DatabaseConfiguration(connection, connectUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI)).getSection("persistence")).getParameterValue("basepath_databackup")) == null) {
            throw new HdbException("Parameter '" + DatabaseConfiguration.ConfigFileName.GLOBAL_INI.toString() + " -> " + "persistence" + " -> basepath_databackup' is not set.");
        }
        LogFactory.writeLogEntry(this.getClass(), "Default database backup location: " + location);
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (location.contains("$(DIR_INSTANCE)")) {
            LogFactory.writeLogEntry(this.getClass(), "Instance directory: " + instanceDir);
            if (instanceDir != null) {
                location = location.replaceAll(Pattern.quote("$(DIR_INSTANCE)"), instanceDir.replaceAll(Pattern.quote("\\"), "\\\\\\\\"));
                LogFactory.writeLogEntry(this.getClass(), "Processed database backup location: " + location);
            }
        }
        this.backupLocation = location = location.replaceAll(Pattern.quote("\\"), "/");
        if (this.list(port, location + "/DB_" + this.tenantSid.getValue())) {
            location = location + "/DB_" + this.tenantSid.getValue();
        }
        LogFactory.writeLogEntry(this.getClass(), "Calculated database backup to location: " + location);
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/usr/bin/unzip -o " + this.archive + " -d " + location;
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "BackupArchives_EXTRACT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Backup extraction failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup archive extracted.");
        return true;
    }

    public boolean unzipBackupPython(SAPControlPortType port) {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setConnectUser(connectUser);
        if (connection.isMultiDB()) {
            connectUser = this.systemDatabaseSystemUser;
            this.database.setSid(new Sid("SYSTEMDB"));
            connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        String location = this.target;
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (location == null) {
            DatabaseConfiguration configuration = new DatabaseConfiguration(connection, connectUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
            DatabaseConfigurationSection persistenceSection = configuration.getSection("persistence");
            location = persistenceSection.getParameterValue("basepath_databackup");
            if (location == null) {
                throw new HdbException("Parameter '" + DatabaseConfiguration.ConfigFileName.GLOBAL_INI.toString() + " -> " + "persistence" + " -> basepath_databackup' is not set.");
            }
            LogFactory.writeLogEntry(this.getClass(), "Default database backup location: " + location);
            if (location.contains("$(DIR_INSTANCE)")) {
                LogFactory.writeLogEntry(this.getClass(), "Instance directory: " + instanceDir);
                if (instanceDir != null) {
                    location = location.replaceAll(Pattern.quote("$(DIR_INSTANCE)"), instanceDir.replaceAll(Pattern.quote("\\"), "\\\\\\\\"));
                    LogFactory.writeLogEntry(this.getClass(), "Processed database backup location: " + location);
                }
            }
            if (this.list(port, (location = location.replaceAll(Pattern.quote("\\"), "/")) + "/DB_" + this.tenantSid.getValue())) {
                location = location + "/DB_" + this.tenantSid.getValue();
            }
            LogFactory.writeLogEntry(this.getClass(), "Calculated database backup to location: " + location);
        }
        this.backupLocation = location;
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/usr/bin/printf import\\ sys\nimport\\ zipfile\nzip_ref=zipfile.ZipFile(sys.argv[1],'r')\nzip_ref.extractall(sys.argv[2])\nzip_ref.close()\n";
        LogFactory.writeLogEntry(this.getClass(), "Creating unzip scrip: " + location + "/unzip.py");
        port.osExecute(command, 0, 0, location + "/unzip.py", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Create of unzip script failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        command = instanceDir + "/HDBSettings.sh " + location + "/unzip.py " + this.archive + " " + location;
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "BackupArchives_EXTRACT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Backup extraction failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup archive extracted.");
        return true;
    }

    public boolean downloadAndUnzipBackupWithPython(SAPControlPortType port, String command) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        System.out.println("Export load jobs: Extracting Archives...");
        String traceFile = this.tenantSid.getValue() + "_ARCHIVE_DOWNLOAD_EXTRACT.trc";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command + " remotely. Output written to file " + traceFile + " in the HANA host trace directory.");
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method:  " + this.helper.getSapcontrolCall() + " -function OSExecute \"" + command + "\" 0 0");
        port.osExecute(command, 0, 0, traceFile, (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Archives download/extract failed. (pid=" + (pid == null ? "null" : (Serializable)pid.value) + "). " + "For more details, check trace file " + this.traceLocation + "trace/" + traceFile + ".");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup archives downloaded and extracted. (pid=" + (pid == null ? "null" : (Serializable)pid.value) + ")");
        return true;
    }

    public boolean downloadAndUnzipBackupWithPythonAsync(SAPControlPortType port, String command) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        System.out.println("Progress: Extracting Archives...");
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 1, 0, this.tenantSid.getValue() + "_ARCHIVE_DOWNLOAD_EXTRACT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Archives download/extract failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        System.out.println("HANA Export Extract Progress: Process " + pid.value + "  started...");
        int extractPID = (Integer)pid.value;
        try {
            for (int i = 0; i < 200; ++i) {
                Thread.sleep(5000L);
                port.sendSignal(extractPID, "0");
                String ls = "/bin/sh -c ls\\ " + this.backupLocation + "/.zips";
                System.out.println(ls);
                port.osExecute(ls, 1, 0, this.tenantSid.getValue() + "_LS_ZIPS.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
                System.out.println(((ArrayOfString)lines.value).getItem());
                ls = "/bin/sh -c ls\\ " + this.backupLocation + "/*databackup*";
                System.out.println(ls);
                port.osExecute(ls, 1, 0, this.tenantSid.getValue() + "_LS_ZIPS.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
                System.out.println(((ArrayOfString)lines.value).getItem());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup archives downloaded and extracted.");
        return true;
    }

    public boolean insertAndUnzipBackupWithPython(SAPControlPortType port, boolean unzip) {
        DatabaseSqlUser loadUser;
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setUserAndConnect(connectUser);
        DatabaseTenant tenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        String systemdbPort = connection.getSystemdbPort();
        if (systemdbPort == null) {
            systemdbPort = tenant.getSqlPort(connection, this.systemUser).get().substring(0, 3) + "13";
        }
        String location = this.target;
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (location == null) {
            location = this.getDefaultLocation(connection, connectUser, instanceDir, port, "basepath_databackup");
        }
        this.backupLocation = this.checkLocation(port, location);
        String script_py1 = this.backupLocation + "/p_download_and_unzip.py";
        this.traceLocation = this.database.getTraceLocation(connection, this.systemUser);
        String[] listOfFiles = this.archive.split(this.PATH_SEPARATOR);
        String[] listOfTables = new String[listOfFiles.length];
        String listOfTablesPython = null;
        Thread[] archives = new Thread[listOfFiles.length];
        try {
            Statement stmt;
            block25: {
                loadUser = this.createLoadUser(connection);
                if (loadUser != null) {
                    connection.setConnectUser(loadUser);
                }
                stmt = connection.createStatement();
                try {
                    stmt.execute("DROP TABLE \"ARCHIVES\"");
                }
                catch (SQLException e) {
                    if (HdbException.INVALID_TABLE_NAME == e.getErrorCode()) break block25;
                    throw e;
                }
            }
            stmt.execute("CREATE TABLE \"ARCHIVES\" (ARCHIVE_TABLE CHAR(50), STATUS CHAR(12))");
            for (int i = 0; i < listOfFiles.length; ++i) {
                archives[i] = new Thread(new BackupArchive(listOfFiles[i], this.jdbcDriver.get().getAbsolutePath(), connection.getUrl(), connection.getConnectUser().getName().get(), connection.getConnectUser().getPassword().get(), connection.getConnectProperties()));
                listOfTables[i] = BackupArchive.getTableNameFromPath(listOfFiles[i]);
                stmt.execute("INSERT INTO \"ARCHIVES\" VALUES ('" + listOfTables[i] + "' ,'INITIAL')");
                listOfTablesPython = i == 0 ? "'" + listOfTables[i] + "'" : listOfTablesPython + ",'" + listOfTables[i] + "'";
            }
            stmt.close();
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), e.toString());
            return false;
        }
        BackupArchive.setMaxConnections(this.parallelJobs);
        for (int i = 0; i < archives.length; ++i) {
            archives[i].start();
        }
        long start = System.nanoTime();
        System.out.println("Export load jobs: Begin loading of archives.");
        boolean alive = true;
        while (alive) {
            int alived = 0;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LogFactory.writeLogEntry(this.getClass(), e.toString());
            }
            alive = false;
            for (int i = 0; i < archives.length; ++i) {
                if (!archives[i].isAlive()) continue;
                ++alived;
                alive = true;
            }
            Set<String> keys = BackupArchive.getStatus().stringPropertyNames();
            int total = 0;
            int success = 0;
            int waiting = 0;
            int running = 0;
            int error = 0;
            int done = 0;
            for (String key : keys) {
                ++total;
                if ("SUCCESS".equals(BackupArchive.getStatus().getProperty(key))) {
                    ++done;
                    ++success;
                    continue;
                }
                if ("ERROR".equals(BackupArchive.getStatus().getProperty(key))) {
                    ++error;
                    ++done;
                    continue;
                }
                if ("INITIAL".equals(BackupArchive.getStatus().getProperty(key)) || "RETRY".equals(BackupArchive.getStatus().getProperty(key))) {
                    ++waiting;
                    continue;
                }
                if (!"INSERTING".equals(BackupArchive.getStatus().getProperty(key))) continue;
                ++running;
            }
            long current = System.nanoTime();
            int percent = (int)((double)done / (double)total * 100.0);
            LogFactory.writeLogEntry(this.getClass(), "Number of active threads: " + alived + ", " + "active connections: " + BackupArchive.getCounter());
            LogFactory.writeLogEntry(this.getClass(), "Archive status(" + percent + "%): " + BackupArchive.getStatus().toString());
            System.out.println("Export load jobs: running " + running + ", waiting " + waiting + ", completed " + success + ", failed " + error + ", total " + total + " (" + percent + "%). Elapsed time: " + BackupArchive.durationMin(start, current) + " minutes...");
        }
        System.out.println("Export load jobs: All archives successfully loaded.");
        this.insertStatus = BackupArchive.getStatus();
        if (this.errorsFound(BackupArchive.getStatus())) {
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "All archives successfully loaded. Starting remote download and extraction...");
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String encryptString = "";
        if (this.database.isEncryptTrue()) {
            encryptString = "encrypt='true', sslValidateCertificate='false', sslKeyStore='sapsrv.pse',";
            LogFactory.writeLogEntry(this.getClass(), "Database encryption enforced. Creating python script with encryption properties: " + encryptString);
        }
        String connectString = "address='localhost', port=" + systemdbPort + ", databaseName='" + this.tenantSid.getValue() + "' ";
        String script1 = "import sys\nimport os\nimport zipfile\nimport threading\nimport logging\nfrom hdbcli import dbapi\nfrom multiprocessing import Pool\nfrom datetime import datetime\n\ndef unzipArchive(zfile):\n  try:\n    if ( zfile.endswith('.SAR')):\n      os.system('" + instanceDir + "/exe/SAPCAR -xf ' + zfile + ' -R ' +targetdir)\n" + "    else:\n" + "      zip_=zipfile.ZipFile(zfile,'r')\n" + "      filesInZip = zip_.namelist()\n" + "      for fileInZip in filesInZip:\n" + "        if fileInZip != 'META-INF/SAPMANIFEST.MF' and fileInZip != 'SIGNATURE.SMF':\n" + "          zip_.extract(fileInZip, targetdir)\n" + "      zip_.close()\n" + "    return 0\n" + "  except:\n" + "    raise\n" + "\n" + "def mprint(line):\n" + "  print(line)\n" + "  logging.info(line)\n" + "\n" + "def tprint(log):\n" + "  lock = threading.Lock()\n" + "  with lock:\n" + "    for l in log:\n" + "      mprint(l)\n" + "\n" + "def tline(tmsg):\n" + "   return str(datetime.now()) + ' [' + str(os.getpid()) + '] ' + tmsg\n" + "\n" + "def treturn(alog, table, aret):\n" + "   alog.append(tline('------- ' + 'END:   ' + table + ' (pid=' + str(os.getpid()) + ') -------'))\n" + "   alog.append(tline(''))\n" + "   tprint(alog)\n" + "   return aret\n" + "\n" + "def downloadArchive(tableName):\n" + "    tlog = []\n" + "    tlog.append(tline(''))\n" + "    tlog.append(tline('------- START: ' + tableName + ' (pid=' + str(os.getpid()) + ') -------'))\n" + "    unzip = " + (unzip ? "True" : "False") + "\n" + "    pw = '" + connection.getConnectUser().getPassword().get() + "'\n" + "    conn = dbapi.connect(" + connectString + ", " + encryptString + "user='" + connection.getConnectUser() + "', password=pw, autocommit=True)\n" + "    for tries in range(1," + (BackupArchive.getMaxRetries() + 1) + "):\n" + "      tlog.append(tline('Downloading table \"' + tableName + '\"... (Try number' + str(tries) + ')'))\n" + "      try:\n" + "        sql = 'SELECT ARCHIVE_NAME, LENGTH(ARCHIVE), ARCHIVE FROM \"' +tableName + '\"'\n" + "        cursor = conn.cursor()\n" + "        cursor.execute(sql)\n" + "        rows = cursor.fetchall()\n" + "        tlog.append(tline('Execute ' + sql))\n" + "        if (len(rows) == 0):\n" + "            tlog.append(tline('ERROR: Table ', tableName,' is unexpectedly empty.'))\n" + "            return treturn(tlog, tableName, -1)\n" + "        for r in rows:\n" + "          a_name = r[0].rstrip()\n" + (unzip ? "          zfile=open(rootdir + '/' + a_name,'wb')\n" : "          zfile=open(targetdir + '/' + a_name,'wb')\n") + "          tlog.append(tline('Writing ' + a_name + ' size ' + str(r[1]) + ' to  ' + zfile.name + '...'))\n" + "          zfile.write(r[2]);\n" + "          zfile.close()\n" + "        del rows\n" + "        if(unzip):\n" + "          tlog.append(tline(zfile.name + ' start extraction.'))\n" + "          if(unzipArchive(zfile.name)==0):\n" + "            os.remove(zfile.name)\n" + "            tlog.append(tline(zfile.name + ' extraction finished successfully.'))\n" + "          else:\n" + "            tlog.append(tline('ERROR: ' + zfile.name + ' extraction failed.'))\n" + "            return treturn(tlog, tableName, -1)\n" + "        sql = 'DROP TABLE \"' +tableName + '\"'\n" + "        cursor.execute(sql)\n" + "        return treturn(tlog, tableName, 0)\n" + "      except dbapi.ProgrammingError as exc:\n" + "        if 259 == exc.errorcode:\n" + "          tlog.append(tline('WARNING: Table ' + tableName + ' not found. Assuming already was downloaded.'))\n" + "          return treturn(tlog, tableName, 1)\n" + "        else:\n" + "          tlog.append(tline('ERROR: Table ' + tableName + ' download exception [' + str(exc) + ']'))\n" + "      except Exception as other:\n" + "          tlog.append(tline('ERROR: Table ' + tableName + ' download exception [' + str(other) + ']'))\n" + "      return treturn(tlog, tableName, -1)\n" + "\n" + "rootdir = '" + this.backupLocation + "/.zips'\n" + "targetdir = '" + this.backupLocation + "'\n" + "tracedir = '" + this.traceLocation + "/trace'\n" + "if __name__ == '__main__':\n" + "  logging.basicConfig(format='%%(message)s', filename= tracedir + '/" + this.tenantSid.getValue() + "_LOAD_EXTRACT.log', level=logging.DEBUG)\n" + "  mprint('')\n" + "  if (len(sys.argv) > 1):\n" + "    mprint(tline('Ignoring arguments...'))\n" + "\n" + "  if not os.path.exists(rootdir):\n" + "    try:\n" + "      os.mkdir(rootdir)\n" + "    except:\n" + "      mprint(tline('Working directory does not exist and can not be created.'))\n" + "      sys.exit(2)\n" + "\n" + "  mprint(tline('Downloading and extracting of all archives started. (pid=' + str(os.getpid()) + ')'))\n" + "  tables = [" + listOfTablesPython + "]\n" + "  pool = Pool(" + (int)Math.ceil((double)BackupArchive.getMaxConnections() / 2.0) + ")\n" + "  result = pool.map(downloadArchive,tables)\n" + "  for r in result:\n" + "    if (r<0):\n" + "      mprint(tline('Errors exist. Check HdbCmdOut.log for more details.'))\n" + "      sys.exit(1)\n" + "mprint(tline('All files downloaded to ' + rootdir))\n" + "try:\n" + "  os.rmdir(rootdir)\n" + "except Exception as e:\n" + "  mprint(tline('Archive directory ' + rootdir +' not deleted. [' + str(e) + ']'))\n" + "mprint(tline('Extracting of all archives finished. Exit(0)'))\n" + "sys.exit(0)\n";
        String command = "/usr/bin/printf " + this.escapeChars(script1);
        LogFactory.writeLogEntry(this.getClass(), "Creating download script " + script_py1 + " using the connection properties: " + connectString);
        port.osExecute(command, 0, 0, script_py1, (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Create download and unzip script failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        String command1 = instanceDir + "/HDBSettings.sh " + script_py1;
        boolean success = this.downloadAndUnzipBackupWithPython(port, command1);
        if (success) {
            System.out.println("Export load jobs: Archives extracted successfully.");
        } else {
            System.out.println("Export load jobs: Archives extraction failed.");
        }
        if (success || loadUser == null) {
            command = "/usr/bin/rm -f " + script_py1;
            LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
            port.osExecute(command, 0, 0, this.tenantSid.getValue() + "_RM_SCRIPT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        }
        if (loadUser != null) {
            this.dropLoadUser(connection, loadUser);
        }
        return success;
    }

    public boolean insertAndUnzipBackupWithPython_new(SAPControlPortType port, boolean unzip) {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setUserAndConnect(connectUser);
        DatabaseTenant tenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        String systemdbPort = connection.getSystemdbPort();
        if (systemdbPort == null) {
            systemdbPort = tenant.getSqlPort(connection, this.systemUser).get().substring(0, 3) + "13";
        }
        String location = this.target;
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (location == null) {
            location = this.getDefaultLocation(connection, connectUser, instanceDir, port, "basepath_databackup");
        }
        this.backupLocation = this.checkLocation(port, location);
        String script_py1 = this.backupLocation + "/p_download_and_unzip.py";
        this.traceLocation = this.database.getTraceLocation(connection, this.systemUser);
        String[] listOfFiles = this.archive.split(this.PATH_SEPARATOR);
        String[] listOfTables = new String[listOfFiles.length];
        String listOfTablesPython = null;
        Thread[] archives = new Thread[listOfFiles.length];
        try {
            Statement stmt;
            block22: {
                DatabaseSqlUser loadUser = this.createLoadUser(connection);
                if (loadUser != null) {
                    connection.setConnectUser(loadUser);
                }
                stmt = connection.createStatement();
                if (loadUser != null) {
                    stmt.execute("GRANT ALL PRIVILEGES ON SCHEMA " + loadUser.getName().get() + " TO " + this.systemUser.getName().get());
                }
                try {
                    stmt.execute("DROP TABLE \"ARCHIVES\"");
                }
                catch (SQLException e) {
                    if (HdbException.INVALID_TABLE_NAME == e.getErrorCode()) break block22;
                    throw e;
                }
            }
            stmt.execute("CREATE TABLE \"ARCHIVES\" (ARCHIVE_TABLE CHAR(50), STATUS CHAR(12))");
            String command1 = instanceDir + "/HDBSettings.sh " + script_py1;
            for (int i = 0; i < listOfFiles.length; ++i) {
                archives[i] = new Thread(new BackupArchive(listOfFiles[i], this.jdbcDriver.get().getAbsolutePath(), connection.getUrl(), connection.getConnectUser().getName().get(), connection.getConnectUser().getPassword().get(), connection.getConnectProperties(), port, command1));
                listOfTables[i] = BackupArchive.getTableNameFromPath(listOfFiles[i]);
                stmt.execute("INSERT INTO \"ARCHIVES\" VALUES ('" + listOfTables[i] + "' ,'INITIAL')");
                listOfTablesPython = i == 0 ? "'" + listOfTables[i] + "'" : listOfTablesPython + ",'" + listOfTables[i] + "'";
            }
            stmt.close();
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), e.toString());
            return false;
        }
        BackupArchive.setMaxConnections(this.parallelJobs);
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String encryptString = "";
        if (this.database.isEncryptTrue()) {
            encryptString = "encrypt='true', sslValidateCertificate='false', sslKeyStore='sapsrv.pse',";
            LogFactory.writeLogEntry(this.getClass(), "Database encryption enforced. Creating python script with encryption properties: " + encryptString);
        }
        String connectString = "address='localhost', port=" + systemdbPort + ", databaseName='" + this.tenantSid.getValue() + "' ";
        String script1 = "import sys\nimport os\nimport zipfile\nimport threading\nimport logging\nfrom hdbcli import dbapi\nfrom multiprocessing import Pool\nfrom datetime import datetime\n\ndef unzipArchive(zfile):\n  try:\n    if ( zfile.endswith('.SAR')):\n      os.system('" + instanceDir + "/exe/SAPCAR -xf ' + zfile + ' -R ' +targetdir)\n" + "    else:\n" + "      zip_=zipfile.ZipFile(zfile,'r')\n" + "      filesInZip = zip_.namelist()\n" + "      for fileInZip in filesInZip:\n" + "        if fileInZip != 'META-INF/SAPMANIFEST.MF' and fileInZip != 'SIGNATURE.SMF':\n" + "          zip_.extract(fileInZip, targetdir)\n" + "      zip_.close()\n" + "    return 0\n" + "  except:\n" + "    raise\n" + "\n" + "def mprint(line):\n" + "  print(line)\n" + "  logging.info(line)\n" + "\n" + "def tprint(log):\n" + "  lock = threading.Lock()\n" + "  with lock:\n" + "    for l in log:\n" + "      mprint(l)\n" + "\n" + "def tline(tmsg):\n" + "   return str(datetime.now()) + ' [' + str(os.getpid()) + '] ' + tmsg\n" + "\n" + "def treturn(alog, table, aret):\n" + "   alog.append(tline('------- ' + 'END:   ' + table + ' (pid=' + str(os.getpid()) + ') -------'))\n" + "   alog.append(tline(''))\n" + "   tprint(alog)\n" + "   return aret\n" + "\n" + "def downloadArchive(tableName):\n" + "    tlog = []\n" + "    tlog.append(tline(''))\n" + "    tlog.append(tline('------- START: ' + tableName + ' (pid=' + str(os.getpid()) + ') -------'))\n" + "    unzip = " + (unzip ? "True" : "False") + "\n" + "    pw = '" + connection.getConnectUser().getPassword().get() + "'\n" + "    conn = dbapi.connect(" + connectString + ", " + encryptString + "user='" + connection.getConnectUser() + "', password=pw, autocommit=True)\n" + "    for tries in range(1," + (BackupArchive.getMaxRetries() + 1) + "):\n" + "      tlog.append(tline('Downloading table \"' + tableName + '\"... (Try number' + str(tries) + ')'))\n" + "      try:\n" + "        sql = 'SELECT ARCHIVE_NAME, LENGTH(ARCHIVE), ARCHIVE FROM \"' +tableName + '\"'\n" + "        cursor = conn.cursor()\n" + "        cursor.execute(sql)\n" + "        rows = cursor.fetchall()\n" + "        tlog.append(tline('Execute ' + sql))\n" + "        if (len(rows) == 0):\n" + "            tlog.append(tline('ERROR: Table ', tableName,' is unexpectedly empty.'))\n" + "            return treturn(tlog, tableName, -1)\n" + "        for r in rows:\n" + "          a_name = r[0].rstrip()\n" + (unzip ? "          zfile=open(rootdir + '/' + a_name,'wb')\n" : "          zfile=open(targetdir + '/' + a_name,'wb')\n") + "          tlog.append(tline('Writing ' + a_name + ' size ' + str(r[1]) + ' to  ' + zfile.name + '...'))\n" + "          zfile.write(r[2]);\n" + "          zfile.close()\n" + "        del rows\n" + "        sql = 'UNLOAD \"' +tableName + '\"'\n" + "        cursor.execute(sql)\n" + "        if(unzip):\n" + "          tlog.append(tline(zfile.name + ' start extraction.'))\n" + "          if(unzipArchive(zfile.name)==0):\n" + "            os.remove(zfile.name)\n" + "            tlog.append(tline(zfile.name + ' extraction finished successfully.'))\n" + "          else:\n" + "            tlog.append(tline('ERROR: ' + zfile.name + ' extraction failed.'))\n" + "            return treturn(tlog, tableName, -1)\n" + "        sql = 'DROP TABLE \"' +tableName + '\"'\n" + "        cursor.execute(sql)\n" + "        return treturn(tlog, tableName, 0)\n" + "      except dbapi.ProgrammingError as exc:\n" + "        if 259 == exc.errorcode:\n" + "          tlog.append(tline('WARNING: Table ' + tableName + ' not found. Assuming already was downloaded.'))\n" + "          return treturn(tlog, tableName, 1)\n" + "        else:\n" + "          tlog.append(tline('ERROR: Table ' + tableName + ' download exception [' + str(exc) + ']'))\n" + "      except Exception as other:\n" + "          tlog.append(tline('ERROR: Table ' + tableName + ' download exception [' + str(other) + ']'))\n" + "      return treturn(tlog, tableName, -1)\n" + "\n" + "rootdir = '" + this.backupLocation + "/.zips'\n" + "targetdir = '" + this.backupLocation + "'\n" + "tracedir = '" + this.traceLocation + "/trace'\n" + "if __name__ == '__main__':\n" + "  logging.basicConfig(format='%%(message)s', filename= tracedir + '/" + this.tenantSid.getValue() + "_LOAD_EXTRACT.log', level=logging.DEBUG)\n" + "  mprint('')\n" + "  if (len(sys.argv) > 1):\n" + "    mprint(tline('Ignoring arguments...'))\n" + "\n" + "  if not os.path.exists(rootdir):\n" + "    try:\n" + "      os.mkdir(rootdir)\n" + "    except:\n" + "      mprint(tline('Working directory does not exist and can not be created.'))\n" + "      sys.exit(2)\n" + "\n" + "  mprint(tline('Downloading and extracting of all archives started. (pid=' + str(os.getpid()) + ')'))\n" + "  downloadArchive(sys.argv[1])\n" + "sys.exit(0)\n";
        String command = "/usr/bin/printf " + this.escapeChars(script1);
        LogFactory.writeLogEntry(this.getClass(), "Creating download script " + script_py1 + " using the connection properties: " + connectString);
        port.osExecute(command, 0, 0, script_py1, (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Create download and unzip script failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        for (int i = 0; i < archives.length; ++i) {
            archives[i].start();
        }
        long start = System.nanoTime();
        System.out.println("Export load jobs: Begin loading of archives.");
        boolean alive = true;
        while (alive) {
            int alived = 0;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LogFactory.writeLogEntry(this.getClass(), e.toString());
            }
            alive = false;
            for (int i = 0; i < archives.length; ++i) {
                if (!archives[i].isAlive()) continue;
                ++alived;
                alive = true;
            }
            Set<String> keys = BackupArchive.getStatus().stringPropertyNames();
            int total = 0;
            int success = 0;
            int waiting = 0;
            int running = 0;
            int error = 0;
            int done = 0;
            for (String key : keys) {
                ++total;
                if ("SUCCESS".equals(BackupArchive.getStatus().getProperty(key))) {
                    ++done;
                    ++success;
                    continue;
                }
                if ("ERROR".equals(BackupArchive.getStatus().getProperty(key))) {
                    ++error;
                    ++done;
                    continue;
                }
                if ("INITIAL".equals(BackupArchive.getStatus().getProperty(key)) || "RETRY".equals(BackupArchive.getStatus().getProperty(key))) {
                    ++waiting;
                    continue;
                }
                if (!"INSERTING".equals(BackupArchive.getStatus().getProperty(key)) && !"DOWNLOADING".equals(BackupArchive.getStatus().getProperty(key))) continue;
                ++running;
            }
            long current = System.nanoTime();
            int percent = (int)((double)done / (double)total * 100.0);
            LogFactory.writeLogEntry(this.getClass(), "Number of active threads: " + alived + ", " + "active connections: " + BackupArchive.getCounter());
            LogFactory.writeLogEntry(this.getClass(), "Archive status(" + percent + "%): " + BackupArchive.getStatus().toString());
            System.out.println("Export load jobs: running " + running + ", waiting " + waiting + ", completed " + success + ", failed " + error + ", total " + total + " (" + percent + "%). Elapsed time: " + BackupArchive.durationMin(start, current) + " minutes...");
        }
        System.out.println("Export load jobs: All archives successfully loaded.");
        this.insertStatus = BackupArchive.getStatus();
        if (this.errorsFound(BackupArchive.getStatus())) {
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "All archives successfully loaded. Starting remote download and extraction...");
        return true;
    }

    private DatabaseSqlUser createLoadUser(JdbcConnection connection) {
        String username = new String("SWPM20LOADER");
        DatabaseSqlUser tmpSqlUser = null;
        try {
            int i = 0;
            do {
                DatabaseSqlUserName userName;
                if (!(tmpSqlUser = DatabaseSqlUserFactory.getUser(userName = new DatabaseSqlUserName(username))).exists(connection, this.systemUser)) {
                    DatabaseSqlUserPassword pw = PasswordFactory.generatePassword(connection, (DatabaseSystemUser)connection.getConnectUser());
                    tmpSqlUser.createNewUserAlterPassword(connection, this.systemUser, pw);
                    break;
                }
                tmpSqlUser = null;
                username = "SWPM20LOADER" + ++i;
            } while (i < 10);
        }
        catch (Exception e) {
            LogFactory.writeLogEntry(this.getClass(), "Can't create load user. Load to continue with SYSTEM user.");
            tmpSqlUser = null;
        }
        return tmpSqlUser;
    }

    private void dropLoadUser(JdbcConnection connection, DatabaseSqlUser tmpUser) {
        tmpUser.dropUser(connection, this.systemUser);
    }

    private boolean errorsFound(Properties status) {
        String success = new String("SUCCESS");
        boolean result = false;
        for (String key : status.stringPropertyNames()) {
            String value = status.getProperty(key);
            if (value.equals(success)) continue;
            result = true;
            LogFactory.writeLogEntry(this.getClass(), "Archive " + key + " not loaded. Current status: " + value + ". Check file " + key + ".log for more details.");
        }
        return result;
    }

    public boolean p_unzipBackupPython(SAPControlPortType port) {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        DatabaseSystemUser connectUser = this.systemUser;
        connection.setConnectUser(connectUser);
        if (connection.isMultiDB()) {
            connectUser = this.systemDatabaseSystemUser;
            this.database.setSid(new Sid("SYSTEMDB"));
            connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        String location = this.target;
        String instanceDir = this.helper.getInstanceDirectory(port);
        if (location == null) {
            location = this.getDefaultLocation(connection, connectUser, instanceDir, port, "basepath_databackup");
        }
        this.backupLocation = this.checkLocation(port, location);
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String script = "import sys\nimport os\nimport zipfile\nfrom multiprocessing import Pool\ndef unzipArchive(zfile):\n  for tries in range(1," + (BackupArchive.getMaxRetries() + 1) + "):\n" + "    print (zfile + ': starting unzip... (Try number ' + str(tries) + ')')\n" + "    try:\n" + "      zip_=zipfile.ZipFile(zfile,'r')\n" + "      filesInZip = zip_.namelist()\n" + "      for fileInZip in filesInZip:\n" + "        if fileInZip != 'META-INF/SAPMANIFEST.MF' and fileInZip != 'SIGNATURE.SMF':\n" + "          zip_.extract(fileInZip, targetdir)\n" + "      zip_.close()\n" + "      print (zfile + ': unzip successful.')\n" + "      return 0\n" + "    except Exception as e:\n" + "      print (zfile + ': Unexpected error [' + str(e) + ']')\n" + "  return -1\n" + "\n" + "archives = \"" + this.archive + "\"\n" + "targetdir = \"" + this.backupLocation + "\"\n" + "if __name__ == '__main__':\n" + "  if not os.path.exists(targetdir):\n" + "    sys.exit(2)\n" + "\n" + "zips = archives.split(\":\")\n" + "pool = Pool(" + (int)Math.ceil((double)BackupArchive.getMaxConnections() / 2.0) + ")\n" + "result = pool.map(unzipArchive,zips)\n" + "for r in result:\n" + "  if (r<0):\n" + "    print ('Errors exist. Check HdbCmdOut.log for more details.')\n" + "    sys.exit(1)\n" + "print ('All files extracted to ' + targetdir)\n" + "sys.exit(0)\n";
        String command = "/usr/bin/printf " + this.escapeChars(script);
        LogFactory.writeLogEntry(this.getClass(), "Creating unzip scrip: " + location + "/p_unzip.py");
        port.osExecute(command, 0, 0, location + "/p_unzip.py", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Create unzip script failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        command = instanceDir + "/HDBSettings.sh " + location + "/p_unzip.py";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "BackupArchives_EXTRACT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Backup extraction failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        command = "/usr/bin/rm -f " + location + "/p_unzip.py";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "RM_SCRIPT.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        LogFactory.writeLogEntry(this.getClass(), "Backup archive extracted.");
        return true;
    }

    private String getDefaultLocation(JdbcConnection connection, DatabaseSystemUser connectUser, String instanceDir, SAPControlPortType port, String param) {
        DatabaseConfiguration configuration = new DatabaseConfiguration(connection, connectUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection persistenceSection = configuration.getSection("persistence");
        String location = persistenceSection.getParameterValue(param);
        if (location == null) {
            throw new HdbException("Parameter '" + DatabaseConfiguration.ConfigFileName.GLOBAL_INI.toString() + " -> " + "persistence" + " -> " + param + "' is not set.");
        }
        LogFactory.writeLogEntry(this.getClass(), "Default " + param + " location: " + location);
        if (location.contains("$(DIR_INSTANCE)")) {
            LogFactory.writeLogEntry(this.getClass(), "Instance directory: " + instanceDir);
            if (instanceDir != null) {
                location = location.replaceAll(Pattern.quote("$(DIR_INSTANCE)"), instanceDir.replaceAll(Pattern.quote("\\"), "\\\\\\\\"));
                LogFactory.writeLogEntry(this.getClass(), "Processed " + param + " location: " + location);
            }
        }
        if (this.list(port, (location = location.replaceAll(Pattern.quote("\\"), "/")) + "/DB_" + this.tenantSid.getValue())) {
            location = location + "/DB_" + this.tenantSid.getValue();
        }
        LogFactory.writeLogEntry(this.getClass(), "Calculated " + param + " to location: " + location);
        return location;
    }

    private String checkLocation(SAPControlPortType port, String location) {
        if (!this.list(port, location)) {
            this.mkdir(port, location);
        }
        LogFactory.writeLogEntry(this.getClass(), "Location for backup confirmed:  " + location);
        return location;
    }

    private String escapeChars(String script) {
        String escapedString = script.replace(" ", "\\\\ ");
        return escapedString;
    }

    public boolean extractBackup() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        return this.p_unzipBackupPython(port);
    }

    public boolean insertAndExtractBackup(boolean unzip) {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        return this.insertAndUnzipBackupWithPython(port, unzip);
    }

    public boolean listBackup(SAPControlPortType port) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c ls\\ " + this.archive + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "BackupArchives_LIST.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Backup list failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup archive checked.");
        return true;
    }

    public boolean listBackup() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        return this.listBackup(port);
    }

    public boolean deleteBackup(SAPControlPortType port) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c rm\\ " + this.archive + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "BackupArchives_DELETE.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Backup delete failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup archive deleted.");
        return true;
    }

    public boolean deleteBackup() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.osUser.getName().get(), this.osUser.getPassword().get());
        boolean result = false;
        if (this.listBackup(port)) {
            result = this.deleteBackup(port);
        }
        return result;
    }

    public boolean list(SAPControlPortType port, String fileOrDir) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c ls\\ " + fileOrDir + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "FileOrDir_LIST.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "File or Dir list failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "File or Dir checked.");
        return true;
    }

    public boolean mkdir(SAPControlPortType port, String dir) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String command = "/bin/sh -c mkdir\\ -p\\ " + dir + "";
        LogFactory.writeLogEntry(this.getClass(), "Execute: " + command);
        port.osExecute(command, 0, 0, "mkdir.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "mkdir failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            throw new HdbException("Directory " + dir + " is not available for recovery action. Please solve any existing issue and retry.");
        }
        LogFactory.writeLogEntry(this.getClass(), "mkdir successfully executed.");
        return true;
    }

    @Override
    public void execute() {
        LogFactory.writeLogEntry(this.getClass(), "BackupArchive action:  " + this.action);
        if (this.action.equalsIgnoreCase("LIST")) {
            LogFactory.writeLogEntry(this.getClass(), "Listing " + this.archive);
            this.resultWriter.append(String.valueOf(this.listBackup()));
        } else if (this.action.equalsIgnoreCase("DELETE")) {
            this.archive = this.archive + "_databackup*";
            LogFactory.writeLogEntry(this.getClass(), "Deleting " + this.archive);
            this.resultWriter.append(String.valueOf(this.deleteBackup()));
        } else if (this.action.equalsIgnoreCase("EXTRACT")) {
            LogFactory.writeLogEntry(this.getClass(), "Extracting  " + this.archive);
            this.resultWriter.append(String.valueOf(this.extractBackup()));
            this.resultWriter.append(this.target);
        } else if (this.action.equalsIgnoreCase("INSERT_EXTRACT")) {
            LogFactory.writeLogEntry(this.getClass(), "Loading   " + this.archive);
            this.resultWriter.append(String.valueOf(this.insertAndExtractBackup(true)));
            this.resultWriter.append(this.target);
            this.resultWriter.append(this.insertStatus.toString());
        } else if (this.action.equalsIgnoreCase("INSERT_DOWNLOAD")) {
            LogFactory.writeLogEntry(this.getClass(), "Loading   " + this.archive);
            this.resultWriter.append(String.valueOf(this.insertAndExtractBackup(false)));
            this.resultWriter.append(this.target);
            this.resultWriter.append(this.insertStatus.toString());
        } else {
            LogFactory.writeLogEntry(this.getClass(), "No action perform on Archive " + this.archive + ".");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public String getCachedBackupLocation() {
        return this.backupLocation;
    }
}

