/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionResult;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterImpl;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public abstract class BatchExecutionBase
implements CmdClazz {
    protected CmdClazzParameterMap parameters = null;
    protected ResultFileWriter writer = null;
    protected BatchExecutionResult resultKeeper;

    protected void executeCmdClazzes(CmdClazzNameIF[] cmdClazzNames) {
        for (CmdClazzNameIF clazzName : cmdClazzNames) {
            this.executeCmdClazz(clazzName);
        }
    }

    protected void executeCmdClazz(CmdClazzNameIF cmdClazzName) {
        CmdClazzParameterName parameterName = CmdClazzParameterName.HDB_CMD_CLAZZ_NAME;
        String parameterValue = cmdClazzName.getClazzName();
        LogFactory.writeLogEntry(this.getClass(), "------------------------------------------------------------------------");
        LogFactory.writeLogEntry(this.getClass(), "Next clazz for BatchExecution is: " + parameterValue);
        CmdClazzParameterImpl parameter = new CmdClazzParameterImpl(parameterValue);
        parameter.setCmdClazzParameterName(parameterName);
        this.parameters.put(parameterName, parameter);
        CmdClazzFactory cmdClazzFactory = new CmdClazzFactory(this.parameters);
        CmdClazz cmdClazz = cmdClazzFactory.getInstanceOfClazz();
        cmdClazz.setArguments(this.parameters);
        cmdClazz.setResultFileWriter(this.writer);
        if (cmdClazz instanceof BatchExecutionBase) {
            ((BatchExecutionBase)cmdClazz).resultKeeper = this.resultKeeper;
        }
        LogFactory.writeLogEntry(this.getClass(), "Execute HdbCmdClazz: " + cmdClazz.getClass());
        cmdClazz.execute();
        LogFactory.writeLogEntry(this.getClass(), "Execution of HdbCmdClazz: " + cmdClazz.getClass() + " was successful.");
        LogFactory.writeLogEntry(this.getClass(), "------------------------------------------------------------------------");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
    }
}

