/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.MissingPrivileges;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.ArrayList;

public class CheckAbapPrivileges
extends BatchExecutionBase {
    private Database database;
    private DatabaseSystemUser systemUser;
    private DatabaseSqlUser sqlUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private ResultFileWriter resultFileWriter;

    protected CheckAbapPrivileges() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        DatabaseUserRoleName.Role[] roleNames;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.systemUser);
        }
        MissingPrivileges missingPriv = new MissingPrivileges();
        for (DatabaseUserRoleName.Role roleName : roleNames = new DatabaseUserRoleName.Role[]{DatabaseUserRoleName.Role.USER, DatabaseUserRoleName.Role.DBA_COCKPIT, DatabaseUserRoleName.Role.ABAP_SYS_REPO, DatabaseUserRoleName.Role.ABAP_READ, DatabaseUserRoleName.Role.AFL__SYS_AFL_LCAPPS_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_ERPA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_AFLBFL_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_AFLPAL_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_POSDM_AREA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_SOP_AREA_EXECUTE, DatabaseUserRoleName.Role.AFL__SYS_AFL_SOP_AREA_EXECUTE, DatabaseUserRoleName.Role.TABLE_REDISTRIBUTION}) {
            DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(roleName);
            MissingPrivileges missing = role.checkPrivileges(this.connection, this.systemUser, this.sqlUser);
            missingPriv.addMissingPrivileges(missing);
            if (!roleName.equals((Object)DatabaseUserRoleName.Role.USER) && !roleName.equals((Object)DatabaseUserRoleName.Role.DBA_COCKPIT)) continue;
            ArrayList<String> missingRoles = new ArrayList<String>();
            if (PrivilegesUtils.checkRole(this.connection, role.getName().get(), this.sqlUser.getName().get())) continue;
            missingRoles.add(role.getName().get());
            missingPriv.addMissingRoles(missingRoles);
        }
        if (!missingPriv.hasMissing()) {
            this.resultFileWriter.append("true");
        } else {
            this.resultFileWriter.append("false");
            missingPriv.writeToResultFile(this.resultFileWriter);
            missingPriv.writeToHtmlFile();
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

