/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseBackupLocation;
import com.sap.hdb.sl.lib.instance.DatabaseBackupName;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import javax.xml.ws.Holder;

public class CheckDataBackupIntegrity
implements CmdClazz {
    private OperatingSystemUser systemUser;
    private SAPControlWsdlUrl wsdlUrl;
    private DatabaseBackupName backupName;
    private DatabaseBackupLocation backupLocation;
    private ResultFileWriter resultWriter;
    private SAPControlHelper helper = new SAPControlHelper();
    private String lastError = new String("No errors found.");

    protected CheckDataBackupIntegrity() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.systemUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
        this.wsdlUrl = new SAPControlWsdlUrl(parameters);
        this.backupName = new DatabaseBackupName(parameters);
        this.backupLocation = new DatabaseBackupLocation(parameters);
    }

    public boolean checkDataBackupIntegrity(SAPControlPortType port) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        String instanceDir = this.helper.getInstanceDirectory(port);
        boolean onWindows = this.helper.onWindows(port);
        String command = onWindows ? instanceDir + "/exe/hdbbackupdiag -d " + this.backupLocation.getValue() + " -b " + this.backupName.getValue() : instanceDir + "/exe/hdbbackupdiag -v --check -d " + this.backupLocation.getValue() + " -b " + this.backupName.getValue();
        port.osExecute(command, 0, 0, "checkBackupIntegrity.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            LogFactory.writeLogEntry(this.getClass(), "Backup verification failed!");
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
                this.lastError = line;
            }
            return false;
        }
        LogFactory.writeLogEntry(this.getClass(), "Backup verification succeed!");
        return true;
    }

    public boolean checkDataBackupIntegrity() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.systemUser.getName().get(), this.systemUser.getPassword().get());
        return this.checkDataBackupIntegrity(port);
    }

    @Override
    public void execute() {
        try {
            boolean valid = this.checkDataBackupIntegrity();
            this.resultWriter.append(String.valueOf(valid));
            if (!valid) {
                this.resultWriter.append("The backup named '" + this.backupName.getValue() + "' found at " + this.backupLocation.getValue() + " is not valid. Last logged error [" + this.lastError + "] For more information, check HdbCmdOut.log.");
            }
        }
        catch (HdbException e) {
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append("An error occurred while determinig the validity data backup location: " + e.getMessage());
            return;
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

