/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class CheckDbIsolationLevel
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private Database database = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseUser connectUser = null;

    protected CheckDbIsolationLevel() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.connectUser);
        String dbIsolationLevel = this.checkConfiguration(this.connection, this.connectUser);
        this.resultWriter.append(dbIsolationLevel);
    }

    private String checkConfiguration(JdbcConnection connection, DatabaseUser user) {
        LogFactory.writeLogEntry(this.getClass(), "Checking database_isolation configuration...");
        DatabaseConfiguration config = new DatabaseConfiguration(connection, user, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection section = config.getSection("multidb");
        String dbIsolationLevel = section.getParameterValue("database_isolation");
        LogFactory.writeLogEntry(this.getClass(), "Found database_isolation: " + dbIsolationLevel);
        return dbIsolationLevel;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }

    public static enum Result {
        LOW,
        HIGH;

    }
}

