/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.smigr.create.ddl.DatabaseReorgClassificationFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.DatabaseReorgInputFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.RowstoreListFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.SmigrCreateDdlFactory;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlFile;
import com.sap.hdb.sl.lib.smigr.create.ddl.SqlLstFile;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CheckSmigrExecution
implements CmdClazz {
    private ResultFileWriter resultFileWriter = null;
    private SqlLstFile sqlLstFile = null;
    private DatabaseReorgInputFile estimatedFile = null;
    private DatabaseReorgClassificationFile tableClassificationFile = null;
    private RowstoreListFile rowstoreListFile = null;
    private boolean isImport = true;

    protected CheckSmigrExecution() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        String status = parameters.get(CmdClazzParameterName.CALLER_STATUS).getValue();
        if (status.equals("EXPORT")) {
            this.isImport = false;
        }
        this.sqlLstFile = SmigrCreateDdlFactory.getSqlListFile(parameters, this.isImport);
        this.estimatedFile = SmigrCreateDdlFactory.getDatabaseReorgInputFile(this.sqlLstFile);
        this.tableClassificationFile = SmigrCreateDdlFactory.getDatabaseReorgClassificationFile(this.sqlLstFile);
        String rowstoreListDir = this.sqlLstFile.get().getParent();
        this.rowstoreListFile = SmigrCreateDdlFactory.getRowstoreListFile(new File(rowstoreListDir + "/rowstorelist.txt"));
    }

    @Override
    public void execute() {
        String lstFileDirectory;
        checkResult result = checkResult.OK;
        ArrayList<String> headerInformation = new ArrayList<String>();
        HashMap sqlFileMessages = new HashMap();
        String hdbDirForImport = lstFileDirectory = "Directory: " + this.sqlLstFile.get().getParent();
        String lstFile = "File: " + this.sqlLstFile.get().getName();
        String lstFileExistence = "ERROR: File does not exist!";
        String lstFileContainsNoSqlFiles = "Warning: No SQL files are listed in SQLFiles.LST.";
        if (this.sqlLstFile.get().exists()) {
            lstFileExistence = "File exists.";
            if (this.sqlLstFile.hasHeaderInformation()) {
                headerInformation.add("Header information:");
                Map<SqlLstFile.smigrHeaderInformation, String> headerInfo = this.sqlLstFile.getHeaderInformation();
                for (Map.Entry entry : headerInfo.entrySet()) {
                    headerInformation.add((String)entry.getValue());
                }
            } else {
                headerInformation.add("ERROR: File has no header information!");
                result = checkResult.ERROR;
            }
            List<SqlFile> sqlFiles = this.sqlLstFile.getSqlFiles();
            for (SqlFile sqlFile : sqlFiles) {
                lstFileContainsNoSqlFiles = "";
                File file = sqlFile.get();
                ArrayList<String> messages = new ArrayList<String>();
                messages.add("File: " + file.getName());
                if (file.exists()) {
                    messages.add("File exists.");
                } else {
                    messages.add("ERROR: File does not exist!");
                    result = checkResult.ERROR;
                }
                messages.add("");
                sqlFileMessages.put(file.getName(), messages);
            }
        } else {
            result = checkResult.ERROR;
            lstFileContainsNoSqlFiles = "";
        }
        String estimatedFile = "File: ESTIMATED_ROW_COUNT.TXT or HDB_ESTIMATES.TXT";
        String estimatedFileExistence = "WARNING: None of these files exist!";
        if (this.estimatedFile.exists()) {
            estimatedFile = "File: " + this.estimatedFile.get().getName();
            estimatedFileExistence = "File exists.";
        }
        String string = "File: HDB_TABLE_CLASSIFICATION.TXT for systems based on SAP Kernel 7.4*";
        String tableClassificationFileExistence = "WARNING: File does not exist!";
        if (this.tableClassificationFile.exists()) {
            tableClassificationFileExistence = "File exists.";
        } else if (result.equals((Object)checkResult.OK)) {
            result = checkResult.WARNING;
        }
        String rowstoreListFile = "File: rowstorelist.txt for systems based on SAP Kernel 7.2*";
        String rowstoreListFileExistence = "WARNING: File does not exist! Check OSS note 1659383.";
        if (this.rowstoreListFile.exists()) {
            rowstoreListFileExistence = "File exists.";
        } else if (result.equals((Object)checkResult.OK)) {
            result = checkResult.WARNING;
        }
        switch (result) {
            case OK: {
                this.appendToWriters("OK");
                this.appendToWriters("The result check of ABAP report 'SMIGR_CREATE_DDL' was successful.");
                break;
            }
            case ERROR: {
                this.appendToWriters("ERROR");
                this.appendToWriters("ERROR: The result check of ABAP report 'SMIGR_CREATE_DDL' was not successful!");
                this.appendToWriters("Check OSS-note 1921023 for further informations.");
                break;
            }
            case WARNING: {
                this.appendToWriters("WARNING");
                this.appendToWriters("WARNING: The result check of ABAP report 'SMIGR_CREATE_DDL' ended with warnings.");
                this.appendToWriters("Check OSS-note 1921023 for further informations.");
                break;
            }
            default: {
                throw new HdbException((Object)((Object)result) + " Not a valid check result!");
            }
        }
        this.appendToWriters("");
        this.appendToWriters(lstFileDirectory);
        this.appendToWriters(lstFile);
        this.appendToWriters(lstFileExistence);
        for (String string2 : headerInformation) {
            this.appendToWriters(string2);
        }
        this.appendToWriters("");
        this.appendToWriters(estimatedFile);
        this.appendToWriters(estimatedFileExistence);
        this.appendToWriters("");
        this.appendToWriters(string);
        this.appendToWriters(tableClassificationFileExistence);
        this.appendToWriters("");
        if (!lstFileContainsNoSqlFiles.isEmpty()) {
            this.appendToWriters(lstFileContainsNoSqlFiles);
            this.appendToWriters("");
        } else {
            if (this.isImport && sqlFileMessages.size() > 0) {
                this.appendToWriters(hdbDirForImport);
            }
            for (Map.Entry entry : sqlFileMessages.entrySet()) {
                for (String line : (List)entry.getValue()) {
                    this.appendToWriters(line);
                }
            }
        }
        if (this.isImport) {
            this.appendToWriters(hdbDirForImport);
        }
        this.appendToWriters(rowstoreListFile);
        this.appendToWriters(rowstoreListFileExistence);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }

    private void appendToWriters(String line) {
        this.resultFileWriter.append(line);
        LogFactory.writeLogEntry(this.getClass(), line);
    }

    private static enum checkResult {
        OK,
        ERROR,
        WARNING;

    }
}

