/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;

public class CheckSystemUser
extends BatchExecutionBase {
    private JdbcConnection connection;
    private DatabaseSystemUser systemUser;
    static String USER_ADMIN = "USER ADMIN";
    static String CURRENT_USER = "CURRENT_USER";
    static String MONITORING = "MONITORING";

    protected CheckSystemUser() {
    }

    @Override
    public void execute() {
        this.systemUser = DatabaseSystemUserFactory.getUser(this.parameters);
        Database database = InstanceFactory.getDatabaseInstance(this.parameters);
        JdbcDriver jdbcDriver = new JdbcDriver(this.parameters);
        this.connection = JdbcConnectionFactory.getInstance(jdbcDriver, database);
        String userName = this.systemUser.getName().get();
        if (userName.equalsIgnoreCase("SYSTEM")) {
            this.writer.append("true");
            return;
        }
        this.connection.setConnectUser(this.systemUser);
        if (!PrivilegesUtils.checkSysPrivilege(this.connection, USER_ADMIN, CURRENT_USER) && !PrivilegesUtils.checkUserGroup(this.connection)) {
            this.writer.append("false");
            return;
        }
        this.writer.append("true");
    }
}

