/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTimeZone;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CheckTimeZones
implements CmdClazz {
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private ResultFileWriter resultFileWriter;

    protected CheckTimeZones() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        TimeZone defaultTimeZone = TimeZone.getDefault();
        Map<String, DatabaseTimeZone> timeZonesForAllHosts = this.database.getTimeZonesForAllHosts(this.connection, this.systemUser);
        DatabaseTimeZone databaseTimeZone = null;
        for (Map.Entry<String, DatabaseTimeZone> entry : timeZonesForAllHosts.entrySet()) {
            DatabaseTimeZone tz = entry.getValue();
            if (databaseTimeZone == null) {
                databaseTimeZone = tz;
                continue;
            }
            if (databaseTimeZone.equals(tz)) continue;
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append("More than one time zone is configured for the SAP HANA database hosts. Please check your database configuration.");
            return;
        }
        if (databaseTimeZone == null) {
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append("No time zone information could be retrieved from the SAP HANA database host. Please check that the time zones of the application server host and the database host match.");
            return;
        }
        LogFactory.writeLogEntry(this.getClass(), "Installation host time zone: " + defaultTimeZone);
        LogFactory.writeLogEntry(this.getClass(), "Database host time zone: " + databaseTimeZone);
        int defaultTimeZoneOffset = defaultTimeZone.getOffset(System.currentTimeMillis()) / 1000;
        int databaseTimeZoneOffset = databaseTimeZone.getOffset();
        LogFactory.writeLogEntry(this.getClass(), "Installation host time zone offset: " + defaultTimeZoneOffset);
        LogFactory.writeLogEntry(this.getClass(), "Database host time zone offset: " + databaseTimeZoneOffset);
        if (defaultTimeZoneOffset != databaseTimeZoneOffset) {
            this.resultFileWriter.append(String.valueOf(false));
            this.resultFileWriter.append("The time zone of the application server (" + defaultTimeZone.getDisplayName(defaultTimeZone.inDaylightTime(new Date()), 0, Locale.ENGLISH) + ", offset from GMT: " + defaultTimeZoneOffset + ") doesn't match the time zone of the database server (" + databaseTimeZone.getName() + ", offset from GMT: " + databaseTimeZoneOffset + "). Please ensure that the application server host and the database server host have the same time zone, otherwise the application server will not be able to start up.");
            return;
        }
        this.resultFileWriter.append(String.valueOf(true));
        this.resultFileWriter.append("The time zones of the application server and the database server match.");
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

