/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.extension.ExtCmdClazzName;
import com.sap.hdb.sl.lib.extension.ExtensionFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;

public class CmdClazzFactory {
    private static final String PACKAGE_NAME = CmdClazzFactory.class.getPackage().getName();
    private CmdClazzNameIF cmdClassName = null;
    private CmdClazz cmdClass = null;

    public CmdClazzFactory(CmdClazzParameterMap parameters) {
        CmdClazzParameter param = parameters.get(CmdClazzParameterName.HDB_CMD_CLAZZ_NAME);
        this.cmdClassName = CmdClazzFactory.toCmdClassName(param.getValue());
    }

    public CmdClazz getInstanceOfClazz() {
        Class<? extends CmdClazz> commandClass = this.cmdClassName.getClazz();
        try {
            this.cmdClass = commandClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new HdbException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e.getMessage(), e);
        }
        return this.cmdClass;
    }

    public CmdClazzNameIF getClassName() {
        return this.cmdClassName;
    }

    protected static CmdClazzNameIF toCmdClassName(String className) {
        CmdClazzNameIF commandClassName = null;
        block0: for (ExtCmdClazzName clazz : ExtensionFactory.getCmdClazzNameClasses()) {
            for (CmdClazzNameIF name : clazz.values()) {
                String commandClassNameString = name.getClazzName();
                if (!name.toString().equalsIgnoreCase(className) && !commandClassNameString.equalsIgnoreCase(className)) continue;
                commandClassName = name;
                continue block0;
            }
        }
        if (null == commandClassName) {
            for (CmdClazzName name : CmdClazzName.values()) {
                String commandClassNameString = name.getClazzName();
                if (!name.toString().equalsIgnoreCase(className) && !commandClassNameString.equalsIgnoreCase(className)) continue;
                commandClassName = name;
                break;
            }
        }
        if (null == commandClassName) {
            throw new HdbException(PACKAGE_NAME + "." + className + " no such CmdClazz!");
        }
        return commandClassName;
    }
}

