/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.extension.ExtCmdClazzParameterName;
import com.sap.hdb.sl.lib.extension.ExtensionFactory;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzNameIF;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterImpl;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;

public class CmdClazzParameterFactory {
    private String[] args = null;
    private String wrongFormat = ", Wrong format. Arguments must have the format key=value!";

    public CmdClazzParameterFactory(String[] args) {
        if (null == args) {
            throw new HdbException("args must not be null!");
        }
        for (String arg : args) {
            if (!arg.contains("=")) {
                throw new HdbException(arg + this.wrongFormat);
            }
            this.getParameterKey(arg);
            this.getParameterValue(arg);
        }
        this.args = args;
    }

    public CmdClazzParameterMap getCmdClazzParameter() {
        CmdClazzParameterMap parameterMap = this.createClassParameterMap(this.args);
        if (parameterMap.isSet(CmdClazzParameterName.INTERACTIVE_STDIN, "true")) {
            if (!parameterMap.containsKey(CmdClazzParameterName.HDB_CMD_CLAZZ_NAME)) {
                parameterMap.put(CmdClazzParameterName.HDB_CMD_CLAZZ_NAME, new CmdClazzParameterImpl(CmdClazzName.GET_INTERACTIVE_CLAZZES.toString()));
            }
            CmdClazzParameterMap interactiveParameters = this.getParametersFromInteractiveStdin(parameterMap);
            parameterMap.putAll(interactiveParameters);
        } else if (parameterMap.isSet(CmdClazzParameterName.READ_FROM_STDIN, "true")) {
            CmdClazzParameterMap interactiveParameters = this.getParametersFromStdin();
            parameterMap.putAll(interactiveParameters);
        }
        System.out.println(this.getClass() + ", parameters received. Start execution. Check HdbCmdOut.log and HdbStdout.txt for further information.");
        return parameterMap;
    }

    private CmdClazzParameterMap createClassParameterMap(String[] arguments) {
        CmdClazzParameterMap parameterMap = new CmdClazzParameterMap();
        for (String arg : arguments) {
            String key = this.getParameterKey(arg);
            String parameterValue = this.getParameterValue(arg);
            CmdClazzParameterNameIF parameterName = this.createClassParameterName(key);
            CmdClazzParameter parameter = this.createClassParameter(parameterName, parameterValue);
            parameterMap.put(parameterName, parameter);
        }
        return parameterMap;
    }

    private CmdClazzParameter createClassParameter(CmdClazzParameterNameIF parameterName, String parameterValue) {
        Class<? extends CmdClazzParameter> referenceClass = this.getReferenceClass(parameterName);
        CmdClazzParameter instance = null;
        if (parameterName.hasPublicConstructor()) {
            Constructor<? extends CmdClazzParameter> constructor = this.getConstructor(referenceClass);
            instance = this.getInstance(constructor, parameterValue);
        } else if (parameterName.hasFactory()) {
            Class<?> factoryClass = parameterName.getFactoryClass();
            Method method = this.getMethodFromFactoryClass(factoryClass, parameterName);
            instance = this.getInstanceFromFactory(factoryClass, method, parameterValue);
        } else {
            throw new HdbException(referenceClass + " Cannot initialize class. Class must have public constructor or factory class!");
        }
        instance.setCmdClazzParameterName(parameterName);
        return instance;
    }

    private CmdClazzParameter getInstanceFromFactory(Class<?> factoryClass, Method method, String parameterValue) {
        try {
            return (CmdClazzParameter)method.invoke(factoryClass, parameterValue);
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new HdbException(e.getMessage());
        }
    }

    public Method getMethodFromFactoryClass(Class<?> factoryClass, CmdClazzParameterNameIF parameterName) {
        Method[] methods;
        Class<? extends CmdClazzParameter> parameterClass = parameterName.getReferenceClass();
        for (Method method : methods = factoryClass.getMethods()) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(parameterClass) || parameterTypes.length != 1 || !parameterTypes[0].equals(String.class)) continue;
            return method;
        }
        throw new HdbException(factoryClass + " No method found with return type " + parameterName.getReferenceClass() + " and one parameter of type java.lang.String !");
    }

    private CmdClazzParameter getInstance(Constructor<? extends CmdClazzParameter> constructor, String parameterValue) {
        try {
            return constructor.newInstance(parameterValue);
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new HdbException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new HdbException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new HdbException(e.getCause().getMessage());
        }
    }

    private Constructor<? extends CmdClazzParameter> getConstructor(Class<? extends CmdClazzParameter> referenceClass) {
        try {
            return referenceClass.getConstructor(String.class);
        }
        catch (SecurityException e) {
            throw new HdbException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new HdbException(referenceClass.getName() + " Class needs a constructor with one parameter of type java.lang.String !");
        }
    }

    private Class<? extends CmdClazzParameter> getReferenceClass(CmdClazzParameterNameIF name) {
        return name.getReferenceClass();
    }

    private CmdClazzParameterNameIF createClassParameterName(String key) {
        CmdClazzParameterNameIF parameterName = null;
        try {
            for (ExtCmdClazzParameterName clazz : ExtensionFactory.getCmdClazzParameterNameClasses()) {
                if (!clazz.has(key)) continue;
                parameterName = clazz.valueOf(key);
                break;
            }
            if (null == parameterName) {
                parameterName = CmdClazzParameterName.valueOf(key);
            }
        }
        catch (IllegalArgumentException e) {
            throw new HdbException(key + ", error during conversion into CmdClazzParameter: " + e.getMessage());
        }
        return parameterName;
    }

    private String getParameterValue(String keyValue) {
        String value = null;
        int i = keyValue.indexOf("=");
        if (i > 0) {
            value = keyValue.substring(i + 1);
            if (value.length() == 0) {
                throw new HdbException(keyValue + this.wrongFormat);
            }
            value = value.trim();
        }
        return value;
    }

    private String getParameterKey(String keyValue) {
        String key = null;
        int i = keyValue.indexOf("=");
        if (i > 0) {
            key = keyValue.substring(0, i);
            if (key.length() == 0) {
                throw new HdbException(keyValue + this.wrongFormat);
            }
        } else {
            throw new HdbException(keyValue + this.wrongFormat);
        }
        key = key.trim();
        key = key.toUpperCase(Locale.ENGLISH);
        return key;
    }

    private CmdClazzParameterMap getParametersFromInteractiveStdin(CmdClazzParameterMap parameterMap) {
        CmdClazzParameterMap interactiveParameters = new CmdClazzParameterMap();
        CmdClazzParameter clazzName = parameterMap.get(CmdClazzParameterName.HDB_CMD_CLAZZ_NAME);
        CmdClazzNameIF clazz = CmdClazzFactory.toCmdClassName(clazzName.getValue());
        if (clazz.doesSupportInteractiveStdin()) {
            CmdClazzParameterNameIF[] parameterNames;
            ArrayList<String> stdinParameterValues = new ArrayList<String>();
            for (CmdClazzParameterNameIF parameter : parameterNames = clazz.getCmdClazzParameterNames()) {
                if (parameterMap.containsKey(parameter)) continue;
                String parameterString = parameter.toString();
                String value = "";
                if (parameterString.contains("PASSWORD")) {
                    char[] password = System.console().readPassword("Enter value for " + parameterString + "=", new Object[0]);
                    value = new String(password);
                } else {
                    value = System.console().readLine("Enter value for " + parameterString + "=", new Object[0]);
                }
                stdinParameterValues.add(parameter.toString() + "=" + value.trim());
            }
            interactiveParameters = this.createClassParameterMap(stdinParameterValues.toArray(new String[stdinParameterValues.size()]));
            if (clazz.isSystemDbPasswordRequired()) {
                parameterMap.putAll(interactiveParameters);
                Database database = InstanceFactory.getDatabaseInstance(parameterMap);
                JdbcDriver jdbcDriver = new JdbcDriver(parameterMap);
                JdbcConnection connection = JdbcConnectionFactory.getInstance(jdbcDriver, database);
                if (connection.isMultiDB()) {
                    String parameterString = CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD.toString();
                    String value = "";
                    char[] password = System.console().readPassword("Enter value for " + parameterString + "=", new Object[0]);
                    value = new String(password);
                    stdinParameterValues.add(parameterString + "=" + value.trim());
                    interactiveParameters = this.createClassParameterMap(stdinParameterValues.toArray(new String[stdinParameterValues.size()]));
                }
            }
        } else {
            String message = clazzName.getValue() + ", HdbCmdClazz does not support interactive stdin.";
            System.out.println(message);
            LogFactory.writeLogEntry(this.getClass(), message);
            System.exit(1);
        }
        return interactiveParameters;
    }

    private CmdClazzParameterMap getParametersFromStdin() {
        CmdClazzParameterMap stdinParameters = new CmdClazzParameterMap();
        byte[] buffer = new byte[80];
        String input = "";
        String lineSep = System.getProperty("line.separator");
        try {
            int read;
            while ((read = System.in.read(buffer, 0, 80)) != -1) {
                input = input + new String(buffer, 0, read, "UTF-8");
            }
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
        stdinParameters = this.createClassParameterMap(input.split(lineSep));
        return stdinParameters;
    }
}

