/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterNameIF;
import java.util.HashMap;
import java.util.Map;

public class CmdClazzParameterMap
extends HashMap<CmdClazzParameterNameIF, CmdClazzParameter> {
    private static final long serialVersionUID = -170637807600123827L;

    public CmdClazzParameter get(CmdClazzParameterNameIF name) {
        if (!this.containsKey(name)) {
            throw new HdbException(name + " Mandatory CmdClazzParameter not set!");
        }
        return (CmdClazzParameter)super.get(name);
    }

    public <T extends CmdClazzParameter> T get(CmdClazzParameterNameIF name, Class<T> parameterClass) {
        if (name.getReferenceClass() != parameterClass) {
            throw new HdbException("Parameter class must be equal to parameter reference class.");
        }
        CmdClazzParameter cmdClazzParameter = this.get(name);
        return (T)((CmdClazzParameter)parameterClass.cast(cmdClazzParameter));
    }

    @Override
    public void putAll(Map<? extends CmdClazzParameterNameIF, ? extends CmdClazzParameter> arg0) {
        for (Map.Entry<? extends CmdClazzParameterNameIF, ? extends CmdClazzParameter> newParameter : arg0.entrySet()) {
            CmdClazzParameterNameIF parameterName = newParameter.getKey();
            CmdClazzParameter parameterValue = newParameter.getValue();
            String value = parameterValue.getValue();
            if (value.isEmpty()) {
                super.remove(parameterName);
                continue;
            }
            super.put(parameterName, parameterValue);
        }
    }

    public boolean isSet(CmdClazzParameterNameIF parameterName, String parameterValue) {
        boolean isSet = false;
        if (this.containsKey(parameterName) && parameterValue.equalsIgnoreCase(this.get(parameterName).getValue())) {
            isSet = true;
        }
        return isSet;
    }

    public String[] getOptions() {
        String options = null;
        if (this.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            options = this.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
            options.trim();
            return options.split(",");
        }
        return null;
    }
}

