/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.abap.BasisUtils;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class CreateAbapDatabaseRoles
implements CmdClazz {
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private CmdClazzParameterMap parameters;

    protected CreateAbapDatabaseRoles() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        DatabaseSqlUser tmpSqlUser = null;
        try {
            DatabaseSqlUserName userName;
            for (int i = 1; i < 20 && (tmpSqlUser = DatabaseSqlUserFactory.getUser(userName = new DatabaseSqlUserName("TMPUSER" + i))).exists(this.connection, this.systemUser); ++i) {
            }
            if (this.connection.isProductVersionEqualOrGreaterThan("1.00.110.00.1447753075")) {
                tmpSqlUser.setPassword(PasswordFactory.generatePassword(this.connection, this.systemUser));
                tmpSqlUser.createNewUser(this.connection, this.systemUser);
            } else {
                tmpSqlUser.createNewUserAlterPassword(this.connection, this.systemUser, PasswordFactory.generatePassword(this.connection, this.systemUser));
            }
            this.connection.setConnectUser(this.systemUser);
            String tmpUserGrants = "GRANT ROLE ADMIN TO " + tmpSqlUser.toString();
            this.connection.executeSQLCommand(tmpUserGrants);
            DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.ABAP_READ);
            role.createNewRole(this.connection, tmpSqlUser, this.systemUser);
            role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.ABAP_SYS_REPO);
            role.createNewRole(this.connection, tmpSqlUser, this.systemUser);
            if (this.parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_PASSWORD) && this.parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_NAME)) {
                boolean ibpCloud = false;
                DatabaseSqlUser sqlUser = DatabaseSqlUserFactory.getUser(this.parameters);
                int release = BasisUtils.checkRealCVERSBasisRelease(this.connection, sqlUser);
                if (release >= 782) {
                    ibpCloud = BasisUtils.isIBPCloudSystem(this.connection, sqlUser);
                }
                if (ibpCloud) {
                    role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.ABAP_ADMIN);
                    role.dropRole(this.connection, this.systemUser);
                    role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.ABAP_DEV);
                    role.dropRole(this.connection, this.systemUser);
                }
            }
        }
        finally {
            tmpSqlUser.dropUser(this.connection, this.systemUser);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

