/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationsHelper;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.DatabaseUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class CreateDatabaseConfigurations
implements CmdClazz {
    private Database database;
    private DatabaseUser sqlUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection = null;
    private ResultFileWriter writer;

    protected CreateDatabaseConfigurations() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.sqlUser = DatabaseUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.sqlUser);
        }
        if (this.sqlUser instanceof DatabaseSqlUser) {
            ArrayList<String[]> missingConfigurations = DatabaseConfigurationsHelper.checkConfigurations(this.connection, (DatabaseSqlUser)this.sqlUser);
            for (String[] configuration : missingConfigurations) {
                DatabaseConfiguration config = new DatabaseConfiguration(this.connection, this.sqlUser, DatabaseConfiguration.ConfigFileName.fromString(configuration[0]));
                DatabaseConfigurationSection section = config.getSection(configuration[1]);
                section.setParameter(configuration[2], configuration[3]);
            }
        } else {
            ArrayList<String[]> optionalConfigurations = DatabaseConfigurationsHelper.getConfigurations(this.connection, this.sqlUser);
            this.executeOptionalConfigurations(optionalConfigurations, this.connection);
        }
        this.writer.append("true");
    }

    private void executeOptionalConfigurations(ArrayList<String[]> optionalConfigurations, JdbcConnection connection) {
        for (Object[] objectArray : optionalConfigurations) {
            try {
                DatabaseConfiguration config = new DatabaseConfiguration(connection, this.sqlUser, DatabaseConfiguration.ConfigFileName.fromString(objectArray[0]));
                DatabaseConfigurationSection section = config.getSection((String)objectArray[1]);
                section.setParameter((String)objectArray[2], (String)objectArray[3]);
            }
            catch (HdbException e) {
                LogFactory.writeLogEntry(this.getClass(), "Unable to create configuration '" + Arrays.toString(objectArray) + "': " + e.getMessage());
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }
}

