/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.FileParameter;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CreateDatabaseReorgCheckProcedures
implements CmdClazz {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSystemUser systemUser = null;
    private Database database = null;
    private JdbcConnection connection = null;
    private File checkProcedureFile = null;
    private ResultFileWriter writer;

    protected CreateDatabaseReorgCheckProcedures() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        FileParameter fileParameter = (FileParameter)parameters.get(CmdClazzParameterName.DATABASE_REORG_CHECK_PROCEDURES_FILE);
        this.checkProcedureFile = fileParameter.getFile();
    }

    @Override
    public void execute() {
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.systemUser);
        List<String> content = this.readFromFile();
        StringBuffer statement = new StringBuffer();
        boolean withinComment = false;
        for (String line : content) {
            if (line.contains("/* NEXT STATEMENT */")) {
                this.connection.executeSQLCommand(statement.toString());
                statement = new StringBuffer();
                continue;
            }
            if (line.startsWith("/*") && !line.endsWith("*/")) {
                withinComment = true;
                continue;
            }
            if (line.endsWith("*/")) {
                withinComment = false;
                continue;
            }
            if (line.isEmpty() || line.contains("/*") || withinComment) continue;
            statement.append(line);
            statement.append(" ");
        }
        LogFactory.writeLogEntry(this.getClass(), "Database Reorg Check procedures were created successfully.");
    }

    private List<String> readFromFile() {
        ArrayList<String> content = new ArrayList<String>();
        try {
            BufferedReader bR = new BufferedReader(new FileReader(this.checkProcedureFile));
            String line = bR.readLine();
            while (line != null) {
                content.add(line.trim());
                line = bR.readLine();
            }
            bR.close();
        }
        catch (IOException e) {
            throw new HdbException(e);
        }
        return content;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }
}

