/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.PasswordPolicy;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class CreateDatabaseShadowUser
extends BatchExecutionBase {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSqlUser sqlUser = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUserPassword password = null;
    private Database database = null;
    private JdbcConnection connection = null;
    private ResultFileWriter writer;

    protected CreateDatabaseShadowUser() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.password = PasswordFactory.getDatabaseSqlUserPassword(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if (this.sqlUser.exists(this.connection, this.systemUser)) {
            LogFactory.writeLogEntry(this.getClass(), "User " + this.sqlUser + " already exists. It will be dropped first and then recreated.");
            this.sqlUser.dropUser(this.connection, this.systemUser);
        }
        if (this.connection.isProductVersionEqualOrGreaterThan("1.00.110.00.1447753075")) {
            this.sqlUser.setPassword(this.password);
            this.sqlUser.createNewUser(this.connection, this.systemUser);
            if (null != this.writer) {
                this.writer.append("true");
            }
        } else {
            this.sqlUser.setPassword(PasswordFactory.getDatabaseSqlUserPassword("x" + this.password.get() + "x"));
            this.sqlUser.createNewUser(this.connection, this.systemUser);
            this.sqlUser.alterPassword(this.connection, this.password);
            if (null != this.writer) {
                this.writer.append("true");
            }
        }
        PasswordPolicy passwordPolicy = new PasswordPolicy(this.connection, this.systemUser);
        passwordPolicy.disableProperty(PasswordPolicy.PasswordProperty.MAXIMUM_PASSWORD_LIFETIME, this.sqlUser);
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }
}

