/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.hdi.HDIConstants;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.PasswordPolicy;
import com.sap.hdb.sl.lib.user.password.DatabaseSqlUserPassword;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionResult;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class CreateDatabaseSqlUser
extends BatchExecutionBase {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSqlUser sqlUser = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUserPassword password = null;
    private Database database = null;
    private JdbcConnection connection = null;
    private DatabaseUserRole role = null;

    protected CreateDatabaseSqlUser() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        String userName;
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.password = PasswordFactory.getDatabaseSqlUserPassword(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.role = parameters.containsKey(CmdClazzParameterName.DATABASE_USER_ROLE) ? DatabaseUserRoleFactory.getNewRole(parameters) : ((userName = this.sqlUser.getName().get()).startsWith("DBACOCKPIT") ? null : DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.USER));
        this.parameters = parameters;
    }

    @Override
    public void execute() {
        DatabaseUserRole dbaCockpitRole;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if (this.sqlUser.exists(this.connection, this.systemUser)) {
            LogFactory.writeLogEntry(this.getClass(), "User " + this.sqlUser + " already exists. It will be dropped first and then recreated.");
            try {
                this.checkDropHDI();
            }
            catch (HdbException e) {
                LogFactory.writeLogEntry(this.getClass(), " HDI check for user " + this.sqlUser + " could not be performed. Continue with drop and recreate.");
            }
            this.sqlUser.dropUser(this.connection, this.systemUser);
        }
        if (this.connection.isProductVersionEqualOrGreaterThan("1.00.110.00.1447753075")) {
            this.sqlUser.setPassword(this.password);
            this.sqlUser.createNewUser(this.connection, this.systemUser);
        } else {
            this.sqlUser.setPassword(PasswordFactory.getDatabaseSqlUserPassword("x" + this.password.get() + "x"));
            this.sqlUser.createNewUser(this.connection, this.systemUser);
            this.sqlUser.alterPassword(this.connection, this.password);
        }
        if (this.role != null && this.role.getName().getRole() != DatabaseUserRoleName.Role.DBA_COCKPIT) {
            this.role.grantTo(this.connection, this.systemUser, this.sqlUser);
        }
        if (!(dbaCockpitRole = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.DBA_COCKPIT)).exists(this.connection, this.systemUser)) {
            dbaCockpitRole.createNewRole(this.connection, this.systemUser);
        }
        dbaCockpitRole.grantTo(this.connection, this.systemUser, this.sqlUser);
        PasswordPolicy passwordPolicy = new PasswordPolicy(this.connection, this.systemUser);
        passwordPolicy.disableProperty(PasswordPolicy.PasswordProperty.MAXIMUM_PASSWORD_LIFETIME, this.sqlUser);
    }

    private void checkDropHDI() {
        if (this.sqlUser.getName().get().startsWith("DBACOCKPIT")) {
            return;
        }
        this.resultKeeper = new BatchExecutionResult();
        this.executeCmdClazz(CmdClazzName.HDI_CHECK);
        if (this.resultKeeper.getResult(HDIConstants.HDI_ENABLED).equalsIgnoreCase("true")) {
            this.executeCmdClazz(CmdClazzName.DROP_HDI_CONTAINER_GROUP);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

