/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.LcaAlertsSchema;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.role.AflSysAflLcAppsExecuteRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.user.role.PrivilegesUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.ArrayList;

public class CreateLcaAlertsSchema
implements CmdClazz {
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUserName sqlUserName = null;
    private DatabaseSqlUser sqlUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected CreateLcaAlertsSchema() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.sqlUserName = DatabaseSqlUserFactory.getUser(parameters).getName();
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        DatabaseUserRole role;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if ((role = DatabaseUserRoleFactory.getNewRole(DatabaseUserRoleName.Role.AFL__SYS_AFL_LCAPPS_EXECUTE)).exists(this.connection, this.systemUser)) {
            LcaAlertsSchema lcaAlertsSchema = new LcaAlertsSchema();
            lcaAlertsSchema.createSchema(this.connection, this.systemUser, this.sqlUserName);
            AflSysAflLcAppsExecuteRole lcappsRole = (AflSysAflLcAppsExecuteRole)role;
            ArrayList<String> missingObjectPrivileges = PrivilegesUtils.checkObjectPrivileges(this.connection, this.systemUser, this.sqlUser, lcappsRole.getObjectPrivileges(), this.sqlUser.getName().get());
            if (missingObjectPrivileges.size() > 0) {
                lcaAlertsSchema.grantPrivileges(this.connection, this.systemUser, this.sqlUserName);
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

