/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class CreateRole
implements CmdClazz {
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseUserRole role = null;

    protected CreateRole() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.role = DatabaseUserRoleFactory.getNewRole(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        DatabaseSqlUser tmpSqlUser = null;
        try {
            DatabaseSqlUserName userName;
            for (int i = 1; i < 20 && (tmpSqlUser = DatabaseSqlUserFactory.getUser(userName = new DatabaseSqlUserName("TMPUSER" + i))).exists(this.connection, this.systemUser); ++i) {
            }
            if (this.connection.isProductVersionEqualOrGreaterThan("1.00.110.00.1447753075")) {
                tmpSqlUser.setPassword(PasswordFactory.generatePassword(this.connection, this.systemUser));
                tmpSqlUser.createNewUser(this.connection, this.systemUser);
            } else {
                tmpSqlUser.createNewUserAlterPassword(this.connection, this.systemUser, PasswordFactory.generatePassword(this.connection, this.systemUser));
            }
            this.connection.setConnectUser(this.systemUser);
            String tmpUserGrants = "GRANT ROLE ADMIN TO " + tmpSqlUser.toString();
            this.connection.executeSQLCommand(tmpUserGrants);
            this.role.createNewRole(this.connection, tmpSqlUser, this.systemUser);
        }
        finally {
            tmpSqlUser.dropUser(this.connection, this.systemUser);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

