/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.AuthoringSchemaName;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SchemaMapping;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class CreateSchemaMappingForAbap
implements CmdClazz {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser = null;
    private Database database = null;
    private AuthoringSchemaName authoringSchema;

    protected CreateSchemaMappingForAbap() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.authoringSchema = new AuthoringSchemaName(parameters);
    }

    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        if (connection.getDbVersion() >= 4) {
            LogFactory.writeLogEntry(CreateSchemaMappingForAbap.class, "HANA 4 does not have table _SYS_BI.M_SCHEMA_MAPPING. Skip Schema Mapping stuff...");
            return;
        }
        SchemaMapping schemaMapping = new SchemaMapping(connection, this.systemUser);
        this.createSchemaMapping(schemaMapping, this.authoringSchema.getValue());
    }

    private void createSchemaMapping(SchemaMapping schemaMapping, String sourceSchema) {
        if (schemaMapping.exists(sourceSchema)) {
            if (!schemaMapping.exists(sourceSchema, this.sqlUser)) {
                LogFactory.writeLogEntry(this.getClass(), sourceSchema + " authoring schema already exists for a different physical schema in " + "_SYS_BI.M_SCHEMA_MAPPING" + ".");
                throw new HdbException("A schema mapping for authoring schema " + sourceSchema + " already exists for a different physical schema.");
            }
            LogFactory.writeLogEntry(this.getClass(), sourceSchema + " authoring schema already exists in " + "_SYS_BI.M_SCHEMA_MAPPING" + ".");
        } else {
            schemaMapping.createNewMapping(sourceSchema, this.sqlUser);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

