/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.StrFileForInvertedHashKey;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class CreateSqlFilesForInvertedHashKey
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private File strFileDirectory;
    private Map<String, Map<String, String>> sqlFiles = new HashMap<String, Map<String, String>>();
    private int numberOfColumnTables = 0;
    private int numberOfRowstoreTables = 0;
    private int numberOfTablesWithOneIndexField = 0;

    protected CreateSqlFilesForInvertedHashKey() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        String directory = parameters.get(CmdClazzParameterName.PATH).getValue();
        this.strFileDirectory = new File(directory);
    }

    @Override
    public void execute() {
        File[] allFiles;
        if (!this.strFileDirectory.exists() || !this.strFileDirectory.isDirectory()) {
            throw new HdbException(this.strFileDirectory + " no such directory!");
        }
        for (File file : allFiles = this.strFileDirectory.listFiles()) {
            if (!file.getName().endsWith(".STR.logical") && (!file.getName().endsWith(".STR") || "SAPVIEW.STR".equals(file.getName()))) continue;
            StrFileForInvertedHashKey strFile = new StrFileForInvertedHashKey(file);
            if (strFile.getSqlFileContent().size() > 0) {
                String sqlFileName = strFile.getSqlFileName();
                if (null == sqlFileName || sqlFileName.isEmpty()) {
                    throw new HdbException("Received no filename for file: " + file);
                }
                this.numberOfColumnTables += strFile.getNumberOfColumnTables();
                this.numberOfRowstoreTables += strFile.getNumberOfRowTables();
                this.numberOfTablesWithOneIndexField += strFile.numberOfTablesWithOneIndexField();
                Map<String, String> sqlFileContent = strFile.getSqlFileContent();
                if (this.sqlFiles.containsKey(sqlFileName)) {
                    Map<String, String> existingStatements = this.sqlFiles.get(sqlFileName);
                    existingStatements.putAll(sqlFileContent);
                    this.sqlFiles.put(sqlFileName, existingStatements);
                    continue;
                }
                this.sqlFiles.put(sqlFileName, sqlFileContent);
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), "No statements were created for file: " + file);
        }
        for (Map.Entry<String, Map<String, String>> e : this.sqlFiles.entrySet()) {
            String fileName = e.getKey();
            Map<String, String> sqlFileContent = e.getValue();
            File sqlFile = new File(fileName);
            if (sqlFile.exists()) {
                throw new HdbException(sqlFile + ", file already exists!");
            }
            LogFactory.writeLogEntry(this.getClass(), "Creating file: " + sqlFile);
            PrintWriter pW = this.getPrintWriter(sqlFile);
            for (Map.Entry<String, String> content : sqlFileContent.entrySet()) {
                pW.println("");
                pW.println("ind: " + content.getKey() + "~0");
                pW.println(content.getValue());
            }
            pW.flush();
            pW.close();
        }
        this.resultFileWriter.append("Total number of tables: " + String.valueOf(this.numberOfColumnTables + this.numberOfRowstoreTables));
        this.resultFileWriter.append("Number of columnstore tables: " + this.numberOfColumnTables);
        this.resultFileWriter.append("Number of rowstore tables: " + this.numberOfRowstoreTables);
        this.resultFileWriter.append("Number of tables with one primary key field: " + this.numberOfTablesWithOneIndexField);
    }

    private PrintWriter getPrintWriter(File file) {
        try {
            return new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            throw new HdbException();
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

