/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzName;

public class CreateSqlRoleUserSequence
extends BatchExecutionBase {
    protected CreateSqlRoleUserSequence() {
    }

    @Override
    public void execute() {
        boolean ddlog_seq = true;
        String[] options = this.parameters.getOptions();
        if (null != options && options.length > 0) {
            for (String option : options) {
                String found;
                if (!option.startsWith("DDLOG_SEQ=") || !(found = option.substring(option.indexOf("=") + 1)).equalsIgnoreCase("false") && !found.equalsIgnoreCase("no")) continue;
                ddlog_seq = false;
                LogFactory.writeLogEntry(this.getClass(), "Skip creation of sequence DDLOG_SEQ. Found option " + option);
            }
        }
        DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(this.parameters);
        this.executeCmdClazz(CmdClazzName.CREATE_ROLE);
        this.executeCmdClazz(CmdClazzName.CREATE_DATABASE_SQL_USER);
        this.executeCmdClazz(CmdClazzName.ADD_AFL_ROLES_TO_USER);
        if (DatabaseUserRoleName.Role.DBA_COCKPIT != role.getName().getRole()) {
            this.executeCmdClazz(CmdClazzName.CREATE_TABLE_REDISTRIBUTION_ROLE);
            if (ddlog_seq) {
                this.executeCmdClazz(CmdClazzName.CREATE_SEQUENCE);
            }
        }
        this.writer.append("true");
    }
}

