/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.User;
import com.sap.hdb.sl.lib.utils.HdbUserStore;
import com.sap.hdb.sl.lib.utils.HdbUserStoreFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class CreateUserStore
extends BatchExecutionBase {
    private User connectUser = null;
    private String connectString = null;
    private HdbUserStore.Key key = null;
    private HdbUserStore hdbUserStore = null;
    private OperatingSystemUser osUser = null;
    private ResultFileWriter writer;

    protected CreateUserStore() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.connectString = parameters.get(CmdClazzParameterName.USERSTORE_ENV).getValue();
        this.hdbUserStore = HdbUserStoreFactory.getUserStore(parameters);
        this.key = parameters.containsKey(CmdClazzParameterName.USERSTORE_KEY_NAME) ? HdbUserStoreFactory.getKey(parameters) : HdbUserStore.Key.DEFAULT;
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        if (parameters.containsKey(CmdClazzParameterName.OS_USER_NAME)) {
            this.osUser = OperatingSystemUserFactory.getUser(parameters);
        }
    }

    @Override
    public void execute() {
        if (null == this.osUser) {
            this.hdbUserStore.createEntry(this.key, this.connectString, this.connectUser);
        } else {
            this.hdbUserStore.createEntry(this.osUser, this.key, this.connectString, this.connectUser);
        }
        if (this.key.equals((Object)HdbUserStore.Key.DEFAULT)) {
            HdbsllibMem mem = HdbsllibMem.getInstance();
            mem.save(HdbsllibMem.HDBUSERSTORE, "set");
        }
        if (null != this.writer) {
            this.writer.append("true");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }
}

