/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.du.DU;
import com.sap.hdb.sl.lib.du.DUInStack;
import com.sap.hdb.sl.lib.du.DUPair;
import com.sap.hdb.sl.lib.du.DUReaderDB;
import com.sap.hdb.sl.lib.du.StackXmlReader;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.name.DatabaseSqlUserName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DUCheck
extends BatchExecutionBase {
    private Database database = null;
    private DatabaseUser systemUser = null;
    private DatabaseSqlUserName sqlUserName = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private String stackXml = null;
    List<DUPair> needsUpgradeList = null;
    private ResultFileWriter resultFileWriter = null;
    public static String DUS_FOR_UPDATE = "DUS_FOR_UPDATE";
    private String hdbCompDmp = "";

    protected DUCheck() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        if (parameters.containsKey(CmdClazzParameterName.STACK_XML)) {
            this.stackXml = parameters.get(CmdClazzParameterName.STACK_XML).getValue();
            LogFactory.writeLogEntry(this.getClass(), "Using stack xml " + this.stackXml);
        }
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_NAME)) {
            this.sqlUserName = new DatabaseSqlUserName(parameters.get(CmdClazzParameterName.DATABASE_SQL_USER_NAME).getValue());
        }
        this.readHdbCompDmp(parameters);
        this.needsUpgradeList = new ArrayList<DUPair>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute() {
        List<DU> pluginsInDb;
        List<DU> dUnitsInDb;
        this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        this.connection.setConnectUser(this.systemUser);
        List<Object> dUnitsInStack = new ArrayList();
        ArrayList<DUInStack> dUnitsInHdbCompDmp = new ArrayList<DUInStack>();
        if (this.hdbCompDmp.length() > 0) {
            List<String> comps = this.readHdbCompDmp();
            for (String string : comps) {
                String[] stringArray = string.split(",");
                if (stringArray.length < 4) continue;
                DUInStack du = new DUInStack(stringArray[0], stringArray[1], stringArray[2], stringArray[3], "", "");
                dUnitsInHdbCompDmp.add(du);
            }
        }
        if (null != this.stackXml) {
            try {
                StackXmlReader reader = new StackXmlReader(this.stackXml);
                dUnitsInStack = reader.findDUs();
                LogFactory.writeLogEntry(this.getClass(), "Found delivery units in stack:");
                for (DUInStack dUInStack : dUnitsInStack) {
                    LogFactory.writeLogEntry(this.getClass(), dUInStack.print());
                }
            }
            catch (ParserConfigurationException e) {
                LogFactory.writeLogEntry(this.getClass(), "Error during parsing of stack.xml " + this.stackXml + " message: " + e.getMessage());
                throw new HdbException(e);
            }
            catch (SAXException e) {
                LogFactory.writeLogEntry(this.getClass(), "Error during parsing of stack.xml " + this.stackXml + " message: " + e.getMessage());
                throw new HdbException(e);
            }
            catch (IOException e) {
                LogFactory.writeLogEntry(this.getClass(), "Error during reading of stack.xml " + this.stackXml + " message: " + e.getMessage());
                throw new HdbException(e);
            }
        }
        if (dUnitsInStack.size() > 0) {
            dUnitsInDb = DUReaderDB.listDUs(this.connection);
            pluginsInDb = DUReaderDB.listPlugins(this.connection);
            dUnitsInDb.addAll(pluginsInDb);
            for (DUInStack dUInStack : dUnitsInStack) {
                this.checkOnDB(dUInStack, dUnitsInDb);
            }
        } else if (dUnitsInHdbCompDmp.size() > 0) {
            dUnitsInDb = DUReaderDB.listDUs(this.connection);
            pluginsInDb = DUReaderDB.listPlugins(this.connection);
            dUnitsInDb.addAll(pluginsInDb);
            for (DUInStack dUInStack : dUnitsInHdbCompDmp) {
                this.checkOnDB(dUInStack, dUnitsInDb);
            }
        }
        if (this.needsUpgradeList.size() > 0) {
            if (null != this.resultFileWriter) {
                this.resultFileWriter.append("false");
                for (DUPair pair : this.needsUpgradeList) {
                    if (null == pair.getDuOnDB()) {
                        void var5_17;
                        String string = "";
                        if (pair.getDuInStack().getDELIVERY_UNIT().equalsIgnoreCase(DU.HANA_UMML)) {
                            String string2 = "Please check SAP note 2928582";
                        }
                        this.resultFileWriter.append(pair.getDuInStack().getType() + " " + pair.getDuInStack().getDELIVERY_UNIT() + " with version " + pair.getDuInStack().printVersion() + " is not installed on the database! " + (String)var5_17);
                        continue;
                    }
                    this.resultFileWriter.append(pair.getDuInStack().getType() + " " + pair.getDuInStack().getDELIVERY_UNIT() + " has version on the db: " + pair.getDuOnDB().printVersion() + " and has to be upgraded to version " + pair.getDuInStack().printVersion());
                }
            }
            if (null != this.resultKeeper) {
                this.resultKeeper.addObjectResult(DUS_FOR_UPDATE, this.needsUpgradeList);
            }
        } else {
            if (null != this.resultFileWriter) {
                this.resultFileWriter.append("true");
            }
            if (null != this.resultKeeper) {
                this.resultKeeper.addObjectResult(DUS_FOR_UPDATE, this.needsUpgradeList);
            }
        }
    }

    private boolean checkOnDB(DUInStack duInStack, List<DU> dUnitsInDb) {
        for (DU duInDb : dUnitsInDb) {
            if (!duInStack.sameName(duInDb)) continue;
            if (duInDb.getDuVersion().isVersionBiggerOrEqual(duInStack.getDuVersion())) {
                duInDb.grantHANA_UMMLRole(this.connection, this.sqlUserName);
                return true;
            }
            DUPair pair = new DUPair(duInDb, duInStack);
            this.needsUpgradeList.add(pair);
            return false;
        }
        DUPair pair = new DUPair(null, duInStack);
        this.needsUpgradeList.add(pair);
        return false;
    }

    public void readHdbCompDmp(CmdClazzParameterMap parameters) {
        String[] parts;
        String hdbCompDmpParam = "";
        if (parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            hdbCompDmpParam = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        }
        LogFactory.writeLogEntry(this.getClass(), "Received hdbCompDmp parameteres: " + hdbCompDmpParam);
        hdbCompDmpParam.trim();
        for (String option : parts = hdbCompDmpParam.split(",")) {
            if (option.startsWith("HDBDESTCOMP=")) {
                String found = option.substring(option.indexOf("=") + 1);
                if (found.isEmpty()) continue;
                this.hdbCompDmp = found;
                continue;
            }
            LogFactory.writeLogEntry(this.getClass(), "Unknown option " + option);
        }
    }

    private List<String> readHdbCompDmp() {
        ArrayList<String> comps = new ArrayList<String>();
        File hdbCompDmpFile = new File(this.hdbCompDmp);
        if (!hdbCompDmpFile.exists() || !hdbCompDmpFile.isFile()) {
            LogFactory.writeLogEntry(this.getClass(), "No HDBDESTCOMP.DMP file found. Nothing to do.");
        }
        BufferedReader reader = null;
        try {
            String l;
            reader = new BufferedReader(new FileReader(hdbCompDmpFile));
            while ((l = reader.readLine()) != null) {
                if (!this.isCompLine(l)) continue;
                comps.add(l);
            }
        }
        catch (FileNotFoundException e) {
            throw new HdbException(e.getMessage());
        }
        catch (IOException e) {
            throw new HdbException(e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                throw new HdbException(ex.getMessage());
            }
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new HdbException(e.getMessage());
        }
        return comps;
    }

    private boolean isCompLine(String line) {
        line.trim();
        return !line.contains("#") && line.indexOf(",") >= 0;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

