/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.du.DU;
import com.sap.hdb.sl.lib.du.DUReaderDB;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseConnectUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.utils.cmd.clazz.BatchExecutionBase;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class DU_PluginDump
extends BatchExecutionBase {
    private Database database = null;
    private DatabaseUser connectUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private String dumpFileName = null;
    private ResultFileWriter resultFileWriter = null;

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.parameters = parameters;
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.connectUser = DatabaseConnectUserFactory.getConnectUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        if (parameters.containsKey(CmdClazzParameterName.DU_DUMP_FILE)) {
            this.dumpFileName = parameters.get(CmdClazzParameterName.DU_DUMP_FILE).getValue();
            LogFactory.writeLogEntry(this.getClass(), "Using dump file " + this.dumpFileName);
        }
    }

    @Override
    public void execute() {
        if (null != this.dumpFileName) {
            PrintWriter pw = null;
            File dumpFile = this.createFile(this.dumpFileName);
            try {
                pw = new PrintWriter(new FileWriter(dumpFile, false));
                pw.print(this.getList());
            }
            catch (FileNotFoundException e) {
                throw new HdbException(e.getMessage());
            }
            catch (IOException e) {
                throw new HdbException(e.getMessage());
            }
            finally {
                pw.close();
            }
        } else if (null != this.resultFileWriter) {
            this.resultFileWriter.append(this.getList());
        }
    }

    private String getList() {
        try {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.connectUser);
            List<Object> plugins = new ArrayList();
            List<Object> dus = new ArrayList();
            plugins = DUReaderDB.listPlugins(this.connection);
            dus = DUReaderDB.listDUs(this.connection);
            StringWriter sw = new StringWriter();
            sw.write("#Hana components file\n");
            sw.write("\n");
            sw.write("#Installed plugins:" + plugins.size() + "\n");
            if (plugins.size() > 0) {
                sw.write("#name,version,splevel,patchlevel\n");
                for (DU dU : plugins) {
                    sw.write(dU.getDELIVERY_UNIT() + "," + dU.getVERSION() + "," + dU.getVERSION_SP() + "," + dU.getVERSION_PATCH() + "\n");
                }
            }
            sw.write("\n");
            sw.write("#Installed delivery units:" + dus.size() + "\n");
            if (dus.size() > 0) {
                sw.write("#name,version,splevel,patchlevel\n");
                for (DU dU : dus) {
                    sw.write(dU.getDELIVERY_UNIT() + "," + dU.getVERSION() + "," + dU.getVERSION_SP() + "," + dU.getVERSION_PATCH() + "\n");
                }
            }
            String out = sw.toString();
            sw.close();
            return out;
        }
        catch (IOException e) {
            throw new HdbException(e.getMessage());
        }
    }

    private File createFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new HdbException(fileName + " could not be created!");
                }
            }
            catch (IOException e) {
                throw new HdbException(e.getMessage());
            }
        }
        return file;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

