/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DataStatisticsAdviserCacheDisable
implements CmdClazz {
    private Database database = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private DatabaseSystemUser systemUser = null;
    private String option = null;
    private String datastatisticsadviser = null;
    private String old_datastatisticsadviser = null;
    private String datastatisticsadvisercache_enabled = null;
    private String old_datastatisticsadvisercache_enabled = null;
    public static String DATA_STATISTICS_ADVISER = "[datastatisticsadviser]";
    public static String DATA_STATISTICS_ADVISER_CACHE_ENABLED = "[datastatisticsadvisercache_enabled]";
    DatabaseConfiguration config = null;
    DatabaseConfigurationSection section = null;

    protected DataStatisticsAdviserCacheDisable() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        if (parameters.containsKey(CmdClazzParameterName.ADD_OPTIONS)) {
            this.option = parameters.get(CmdClazzParameterName.ADD_OPTIONS).getValue();
        }
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.connection.setConnectUser(this.systemUser);
        if ("disable".equalsIgnoreCase(this.option)) {
            this.disableJobs();
        } else if ("enable".equalsIgnoreCase(this.option)) {
            this.enableJobs();
        }
    }

    private void disableJobs() {
        this.showState();
        if (this.datastatisticsadviser != null || this.datastatisticsadvisercache_enabled != null) {
            this.saveState();
            this.disable();
        }
    }

    private void enableJobs() {
        this.showState();
        this.readOldState();
        this.restore();
    }

    private void showState() {
        DatabaseConfigurationSection section = this.getConfigSection();
        if (section.isParameterSet("datastatisticsadviser")) {
            this.datastatisticsadviser = section.getParameterValue("datastatisticsadviser");
            LogFactory.writeLogEntry(this.getClass(), "Found indexserver.ini -> [cache] -> datastatisticsadviser: " + this.datastatisticsadviser);
        }
        if (section.isParameterSet("datastatisticsadvisercache_enabled")) {
            this.datastatisticsadvisercache_enabled = section.getParameterValue("datastatisticsadvisercache_enabled");
            LogFactory.writeLogEntry(this.getClass(), "Found indexserver.ini -> [cache] -> datastatisticsadvisercache_enabled: " + this.datastatisticsadvisercache_enabled);
        }
    }

    private DatabaseConfigurationSection getConfigSection() {
        if (null == this.section) {
            this.config = new DatabaseConfiguration(this.connection, this.systemUser, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
            this.section = this.config.getSection("cache");
        }
        return this.section;
    }

    private void saveState() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        if (null != this.datastatisticsadviser) {
            mem.save(DATA_STATISTICS_ADVISER, this.datastatisticsadviser);
        }
        if (null != this.datastatisticsadvisercache_enabled) {
            mem.save(DATA_STATISTICS_ADVISER_CACHE_ENABLED, this.datastatisticsadvisercache_enabled);
        }
    }

    private void readOldState() {
        HdbsllibMem mem = HdbsllibMem.getInstance();
        this.old_datastatisticsadviser = mem.read(DATA_STATISTICS_ADVISER);
        this.old_datastatisticsadvisercache_enabled = mem.read(DATA_STATISTICS_ADVISER_CACHE_ENABLED);
    }

    private void disable() {
        DatabaseConfigurationSection section = this.getConfigSection();
        section.unsetParameter("datastatisticsadviser");
        LogFactory.writeLogEntry(this.getClass(), "Unset indexserver.ini -> [cache] -> datastatisticsadviser");
        section.unsetParameter("datastatisticsadvisercache_enabled");
        LogFactory.writeLogEntry(this.getClass(), "Unset indexserver.ini -> [cache] -> datastatisticsadvisercache_enabled");
    }

    private void restore() {
        DatabaseConfigurationSection section = this.getConfigSection();
        HdbsllibMem mem = HdbsllibMem.getInstance();
        if (null != this.old_datastatisticsadviser && this.old_datastatisticsadviser.length() != 0) {
            section.setParameter("datastatisticsadviser", this.old_datastatisticsadviser);
            LogFactory.writeLogEntry(this.getClass(), "Restored state for indexserver.ini -> [cache] -> datastatisticsadviser to " + this.old_datastatisticsadviser);
            mem.delete(DATA_STATISTICS_ADVISER);
        } else {
            LogFactory.writeLogEntry(this.getClass(), "No old state for indexserver.ini -> [cache] -> datastatisticsadviser found. Nothing to do.");
        }
        if (null != this.old_datastatisticsadvisercache_enabled && this.old_datastatisticsadvisercache_enabled.length() != 0) {
            section.setParameter("datastatisticsadvisercache_enabled", this.old_datastatisticsadvisercache_enabled);
            LogFactory.writeLogEntry(this.getClass(), "Restored state for indexserver.ini -> [cache] -> old_datastatisticsadvisercache_enabled to " + this.old_datastatisticsadvisercache_enabled);
            mem.delete(DATA_STATISTICS_ADVISER_CACHE_ENABLED);
        } else {
            LogFactory.writeLogEntry(this.getClass(), "No old state for indexserver.ini -> [cache] -> old_datastatisticsadvisercache_enabled found. Nothing to do.");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

