/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DatabaseStartStop
implements CmdClazz {
    private Sid tenantSid;
    private DatabaseSystemUser systemDatabaseUser;
    private Database systemDatabase;
    private JdbcDriver jdbcDriver;
    private ResultFileWriter resultWriter;
    private String action;

    protected DatabaseStartStop() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.tenantSid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
        this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.action = parameters.get(CmdClazzParameterName.TENANT_ACTION).getValue();
    }

    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
        DatabaseTenant tenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        if (this.action.equalsIgnoreCase("STOP")) {
            LogFactory.writeLogEntry(this.getClass(), "Stopping HANA tenant " + this.tenantSid);
            tenant.stop(connection, this.systemDatabaseUser);
        } else if (this.action.equalsIgnoreCase("START")) {
            LogFactory.writeLogEntry(this.getClass(), "Starting HANA tenant " + this.tenantSid);
            tenant.start(connection, this.systemDatabaseUser);
        } else {
            LogFactory.writeLogEntry(this.getClass(), "No action perform on Database " + this.tenantSid + ".");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

