/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.AuthoringSchemaName;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SchemaMapping;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DeleteSchemaMappingForAbap
implements CmdClazz {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSystemUser systemUser = null;
    private Database database = null;
    private DatabaseSqlUser sqlUser;
    private AuthoringSchemaName authoringSchema;

    protected DeleteSchemaMappingForAbap() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.authoringSchema = new AuthoringSchemaName(parameters);
    }

    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        SchemaMapping schemaMapping = new SchemaMapping(connection, this.systemUser);
        this.deleteSchemaMapping(schemaMapping, this.authoringSchema.getValue());
    }

    private void deleteSchemaMapping(SchemaMapping schemaMapping, String sourcePackage) {
        if (schemaMapping.exists(sourcePackage, this.sqlUser)) {
            LogFactory.writeLogEntry(this.getClass(), sourcePackage + " Delete source package in " + "_SYS_BI.M_SCHEMA_MAPPING" + ".");
            schemaMapping.deleteMapping(sourcePackage, this.sqlUser);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

