/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.mem.HdbsllibMem;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.utils.HdbUserStore;
import com.sap.hdb.sl.lib.utils.HdbUserStoreFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DeleteUserStore
implements CmdClazz {
    private HdbUserStore.Key key = null;
    private HdbUserStore hdbUserStore = null;
    private OperatingSystemUser osUser = null;
    private ResultFileWriter writer;

    protected DeleteUserStore() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.hdbUserStore = HdbUserStoreFactory.getUserStore(parameters);
        this.key = parameters.containsKey(CmdClazzParameterName.USERSTORE_KEY_NAME) ? HdbUserStoreFactory.getKey(parameters) : HdbUserStore.Key.DEFAULT;
        if (parameters.containsKey(CmdClazzParameterName.OS_USER_NAME)) {
            this.osUser = OperatingSystemUserFactory.getUser(parameters);
        }
    }

    @Override
    public void execute() {
        if (this.key.equals((Object)HdbUserStore.Key.DEFAULT)) {
            HdbsllibMem mem = HdbsllibMem.getInstance();
            String store = mem.read(HdbsllibMem.HDBUSERSTORE);
            if (null != store && store.equalsIgnoreCase("set")) {
                if (null == this.osUser) {
                    this.hdbUserStore.deleteKey(this.key);
                } else {
                    this.hdbUserStore.deleteKey(this.osUser, this.key);
                }
                mem.delete(HdbsllibMem.HDBUSERSTORE);
                LogFactory.writeLogEntry(this.getClass(), "Deleted hdbuserstore, set temporarily from SAPup.");
            } else {
                LogFactory.writeLogEntry(this.getClass(), "hdbuserstore not set from SAPup. Nothing to do");
            }
        } else if (null == this.osUser) {
            this.hdbUserStore.deleteKey(this.key);
        } else {
            this.hdbUserStore.deleteKey(this.osUser, this.key);
        }
        if (null != this.writer) {
            this.writer.append("true");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.writer = writer;
    }
}

