/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SchemaName;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.util.regex.Pattern;

public class DisableDistribution
implements CmdClazz {
    private SchemaName schemaName = null;
    private SchemaName shadowSchemaName = null;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;

    protected DisableDistribution() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.schemaName = new SchemaName(parameters.get(CmdClazzParameterName.SCHEMA_NAME).getValue());
        this.shadowSchemaName = new SchemaName(this.schemaName.getValue() + "SHD");
        this.jdbcDriver = new JdbcDriver(parameters);
    }

    @Override
    public void execute() {
        DatabaseConfiguration globalConfig;
        DatabaseConfigurationSection globalSection;
        String bwSchemaValue;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if ((bwSchemaValue = (globalSection = (globalConfig = new DatabaseConfiguration(this.connection, this.systemUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI)).getSection("table_placement")).getParameterValue("bw_schema")) != null && bwSchemaValue.length() > 0) {
            if ((bwSchemaValue = bwSchemaValue.replaceAll(Pattern.quote(this.shadowSchemaName.getValue()), "").replaceAll(Pattern.quote(this.schemaName.getValue()), "").replaceAll(",+", ",").replaceAll("^,", "").replaceAll(",$", "").trim()).isEmpty()) {
                globalSection.unsetParameter("bw_schema");
                globalSection.unsetParameter("prefix");
                globalSection.unsetParameter("method");
            } else {
                globalSection.setParameter("bw_schema", bwSchemaValue);
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

