/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.DatabaseBackupLocation;
import com.sap.hdb.sl.lib.instance.DatabaseBackupName;
import com.sap.hdb.sl.lib.instance.SAPControlWsdlUrl;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.sapcontrol.ArrayOfString;
import com.sap.hdb.sl.lib.sapcontrol.SAPControlPortType;
import com.sap.hdb.sl.lib.user.OperatingSystemUser;
import com.sap.hdb.sl.lib.user.OperatingSystemUserFactory;
import com.sap.hdb.sl.lib.user.name.OperatingSystemUserName;
import com.sap.hdb.sl.lib.user.password.PasswordFactory;
import com.sap.hdb.sl.lib.utils.SAPControlHelper;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import javax.xml.ws.Holder;

public class DoesDataBackupExist
implements CmdClazz {
    private OperatingSystemUser systemUser;
    private SAPControlWsdlUrl wsdlUrl;
    private DatabaseBackupName backupName;
    private DatabaseBackupLocation backupLocation;
    private ResultFileWriter resultWriter;
    private SAPControlHelper helper = new SAPControlHelper();

    protected DoesDataBackupExist() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.systemUser = OperatingSystemUserFactory.getUser(new OperatingSystemUserName(parameters.get(CmdClazzParameterName.SIDADM_ID).getValue()), PasswordFactory.getOperatingSystemUserPassword(parameters.get(CmdClazzParameterName.SIDADM_PASSWORD).getValue()));
        this.wsdlUrl = new SAPControlWsdlUrl(parameters);
        this.backupName = new DatabaseBackupName(parameters);
        this.backupLocation = new DatabaseBackupLocation(parameters);
    }

    public boolean doesDataBackupExist(SAPControlPortType port) {
        Holder pid = new Holder();
        Holder lines = new Holder();
        Holder exitcode = new Holder();
        boolean onWindows = this.helper.onWindows(port);
        String command = onWindows ? "cmd /c dir " + this.backupLocation.getValue() + "\\" + this.backupName.getValue() + "_databackup*" : "/bin/sh -c ls\\ " + this.backupLocation.getValue() + "/" + this.backupName.getValue() + "_databackup*";
        LogFactory.writeLogEntry(this.getClass(), "SAPControl method: " + this.helper.getSapcontrolCall() + " -function OSExecute \"" + command + "\" 0 0");
        port.osExecute(command, 0, 0, "checkBackupExistence.trc", (Holder<Integer>)exitcode, (Holder<Integer>)pid, (Holder<ArrayOfString>)lines);
        if (exitcode.value == null || (Integer)exitcode.value != 0) {
            for (String line : ((ArrayOfString)lines.value).getItem()) {
                LogFactory.writeLogEntry(this.getClass(), line);
            }
            return false;
        }
        return true;
    }

    public boolean doesDataBackupExist() {
        SAPControlPortType port = this.helper.getPort(this.wsdlUrl.getURL(), this.systemUser.getName().get(), this.systemUser.getPassword().get());
        return this.doesDataBackupExist(port);
    }

    @Override
    public void execute() {
        try {
            boolean exist = this.doesDataBackupExist();
            this.resultWriter.append(String.valueOf(exist));
            if (!exist) {
                this.resultWriter.append("A valid backup with prefix '" + this.backupName.getValue() + "' is not found at the given location " + this.backupLocation.getValue() + ". The correct case-sensitive backup path and file name is needed to continue.");
            }
        }
        catch (HdbException e) {
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append("An error occurred while determinig the default data backup location: " + e.getMessage());
            return;
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

