/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.instance.Instance;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.utils.HdbInstExecutable;
import com.sap.hdb.sl.lib.utils.SystemInformation;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameter;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DoesInstanceExist
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private HdbInstExecutable hdbInstExe = null;
    private Sid sid = null;
    private Instance.Type instanceType = null;

    protected DoesInstanceExist() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.hdbInstExe = (HdbInstExecutable)parameters.get(CmdClazzParameterName.HDBINSTEXE);
        this.sid = (Sid)parameters.get(CmdClazzParameterName.DATABASE_SID);
        CmdClazzParameter type = parameters.get(CmdClazzParameterName.INSTANCE_TYPE);
        this.instanceType = Instance.Type.valueOf(type.getValue());
    }

    @Override
    public void execute() {
        SystemInformation info = new SystemInformation(this.hdbInstExe);
        boolean exists = false;
        if (info.doesInstanceExist(this.instanceType, this.sid)) {
            exists = true;
        }
        this.resultWriter.append(String.valueOf(exists));
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }
}

