/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.du.DU;
import com.sap.hdb.sl.lib.du.DUReaderDB;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseUser;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRole;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleFactory;
import com.sap.hdb.sl.lib.user.role.DatabaseUserRoleName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DoesLcAppsExecuteRoleExist
implements CmdClazz {
    private ResultFileWriter resultWriter = null;
    private Database database = null;
    private DatabaseSystemUser systemUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private Database systemDatabase;
    private DatabaseSystemUser systemDatabaseUser;

    protected DoesLcAppsExecuteRoleExist() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        if (parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
            this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        }
    }

    @Override
    public void execute() {
        DatabaseUser connectUser = null;
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            if (this.connection.isMultiDB() && null != this.systemDatabaseUser) {
                this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
                connectUser = this.systemDatabaseUser;
            } else {
                connectUser = this.systemUser;
            }
        } else {
            connectUser = this.connection.getConnectUser();
        }
        DatabaseUserRoleName.Role roleName = DatabaseUserRoleName.Role.AFL__SYS_AFL_LCAPPS_EXECUTE;
        DatabaseUserRole role = DatabaseUserRoleFactory.getNewRole(roleName);
        boolean roleExists = role.exists(this.connection, connectUser);
        boolean plugingExists = DUReaderDB.pluginExists(this.connection, DU.LCAPPS);
        if (roleExists && plugingExists) {
            this.resultWriter.append(String.valueOf(true));
        } else {
            this.resultWriter.append(String.valueOf(false));
            this.resultWriter.append("SAP liveCache (SAP LCA or LCAPPS-plugin) is not installed on SAP HANA. Details: " + (Object)((Object)roleName) + " , AFL role does not found or LCAPPs pluging is not installed." + " This role is automatically created during the installation of SAP liveCache (SAP LCA or LCAPPS-plugin)." + " Proceed with the installation of SAP liveCache following the description" + " in the 'SAP HANA Server Installation and Update Guide'," + " section 'Installing or Updating SAP HANA Components'." + " This guide is available at: http://help.sap.com/hana_platform," + " -> 'Installation and Update -> SAP HANA Server Installation and Update Guide'.");
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultWriter = writer;
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

