/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.AuthoringSchemaName;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SchemaMapping;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DoesSchemaMappingExist
implements CmdClazz {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSqlUser sqlUser;
    private Database database = null;
    private AuthoringSchemaName authoringSchema;
    private ResultFileWriter resultFileWriter;

    protected DoesSchemaMappingExist() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_SQL_USER_NAME)) {
            this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        }
        this.jdbcDriver = new JdbcDriver(parameters);
        this.authoringSchema = new AuthoringSchemaName(parameters);
    }

    @Override
    public void execute() {
        boolean exists;
        SchemaMapping schemaMapping;
        block4: {
            JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
            connection.setConnectUser(this.systemUser);
            if (connection.isMultiDB() && !connection.doesTenantExist()) {
                this.resultFileWriter.append(String.valueOf(false));
                return;
            }
            schemaMapping = new SchemaMapping(connection, this.systemUser);
            exists = false;
            try {
                exists = schemaMapping.exists(this.authoringSchema.getValue());
            }
            catch (HdbException e) {
                if (!e.getMessage().contains("[259]") || connection.getDbVersion() < 4) break block4;
                LogFactory.writeLogEntry(DoesSchemaMappingExist.class, "HANA 4 does not have table _SYS_BI.M_SCHEMA_MAPPING. Skip Schema Mapping checks...");
                this.resultFileWriter.append(String.valueOf(false));
                return;
            }
        }
        if (this.sqlUser != null) {
            exists = exists && !schemaMapping.exists(this.authoringSchema.getValue(), this.sqlUser);
        }
        this.resultFileWriter.append(String.valueOf(exists));
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

