/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseCatalogObject;
import com.sap.hdb.sl.lib.instance.DatabaseTable;
import com.sap.hdb.sl.lib.instance.DatabaseView;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SchemaMapping;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.IOUtils;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.DisableDistribution;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class DropDatabaseSqlUser
implements CmdClazz {
    private JdbcDriver jdbcDriver = null;
    private DatabaseSqlUser sqlUser = null;
    private DatabaseSystemUser systemUser = null;
    private Database database = null;
    private JdbcConnection connection = null;
    private DisableDistribution disableDistribution = null;

    protected DropDatabaseSqlUser() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        CmdClazzParameterMap disableDistributionParameters = new CmdClazzParameterMap();
        disableDistributionParameters.putAll(parameters);
        disableDistributionParameters.put(CmdClazzParameterName.SCHEMA_NAME, disableDistributionParameters.get(CmdClazzParameterName.DATABASE_SQL_USER_NAME));
        this.disableDistribution = new DisableDistribution();
        this.disableDistribution.setArguments(disableDistributionParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        if (this.sqlUser.exists(this.connection, this.systemUser)) {
            this.sqlUser.dropUser(this.connection, this.systemUser);
        } else {
            LogFactory.writeLogEntry(this.getClass(), this.sqlUser.getName() + " User does not exist or is already deleted.");
        }
        this.disableDistribution.execute();
        SchemaMapping m = new SchemaMapping(this.connection, this.systemUser);
        Map<String, DatabaseSqlUser> userMappingsFromDatabase = m.getMappingsForUserFromDatabase(this.sqlUser);
        for (Map.Entry<String, DatabaseSqlUser> entry : userMappingsFromDatabase.entrySet()) {
            if (!entry.getValue().getName().get().equals(this.sqlUser.getName().get())) continue;
            m.deleteMapping(entry.getKey(), entry.getValue());
        }
        this.connection.setConnectUser(this.systemUser);
        DatabaseView sysTablePlacement = new DatabaseView("SYS", "TABLE_PLACEMENT");
        if (!sysTablePlacement.exists(this.connection)) {
            this.deleteTablePlacementInformation(new DatabaseTable("_SYS_RT", "TABLE_PLACEMENT"));
            return;
        }
        PreparedStatement selectStatement = null;
        ResultSet resultSet = null;
        try {
            selectStatement = this.connection.prepareSQLCommand("SELECT \"SCHEMA_NAME\", \"TABLE_NAME\", \"GROUP_TYPE\", \"SUBTYPE\", \"GROUP_NAME\" FROM " + sysTablePlacement.getFullNameQuoted() + " WHERE \"SCHEMA_NAME\"=?");
            selectStatement.setString(1, this.sqlUser.getName().get());
            resultSet = selectStatement.executeQuery();
            while (resultSet.next()) {
                PreparedStatement alterStatement = null;
                try {
                    alterStatement = this.connection.prepareSQLCommand("ALTER SYSTEM ALTER TABLE PLACEMENT (SCHEMA_NAME => '" + this.escape(resultSet.getString(1)) + "', TABLE_NAME => '" + this.escape(resultSet.getString(2)) + "', GROUP_TYPE => '" + this.escape(resultSet.getString(3)) + "', SUB_TYPE => '" + this.escape(resultSet.getString(4)) + "', GROUP_NAME => '" + this.escape(resultSet.getString(5)) + "') UNSET");
                    alterStatement.executeUpdate();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(alterStatement);
                    throw throwable;
                }
                IOUtils.closeQuietly(alterStatement);
            }
        }
        catch (SQLException e) {
            try {
                throw new HdbException("An error occurred while removing the table placement information: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultSet);
                IOUtils.closeQuietly(selectStatement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(resultSet);
        IOUtils.closeQuietly(selectStatement);
    }

    private boolean deleteTablePlacementInformation(DatabaseCatalogObject object) {
        if (!object.exists(this.connection)) {
            LogFactory.writeLogEntry(this.getClass(), "The " + object.getType().name().toLowerCase(Locale.ENGLISH) + " " + object.getFullName() + " doesn't exist.");
            return false;
        }
        PreparedStatement statement = null;
        try {
            statement = this.connection.prepareSQLCommand("DELETE FROM " + object.getFullNameQuoted() + " WHERE \"SCHEMA_NAME\"=?");
            statement.setString(1, this.sqlUser.getName().get());
            this.connection.executeSQLCommandNoReslt(statement);
        }
        catch (SQLException e) {
            try {
                throw new HdbException("An error occurrend while removing the table placement information: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(statement);
        return true;
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }

    private String escape(String s) {
        return s.replaceAll(Pattern.quote("'"), "\\'");
    }
}

