/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseTenant;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;

public class DropDatabaseTenant
implements CmdClazz {
    private JdbcDriver jdbcDriver = null;
    private Sid tenantSid = null;
    private Database systemDatabase = null;
    private DatabaseSystemUser systemDatabaseUser = null;

    protected DropDatabaseTenant() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.jdbcDriver = new JdbcDriver(parameters);
        this.tenantSid = new Sid(parameters.get(CmdClazzParameterName.DATABASE_SID).getValue());
        this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
        this.systemDatabase = InstanceFactory.getDatabaseInstance(parameters);
        this.systemDatabase.setSid(new Sid("SYSTEMDB"));
    }

    @Override
    public void execute() {
        JdbcConnection connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
        if (this.tenantSid.get().isEmpty()) {
            throw new HdbException("Database SID must not be empty!");
        }
        DatabaseTenant databaseTenant = InstanceFactory.getDatabaseTenant(this.tenantSid, connection);
        if (databaseTenant.exists(connection, this.systemDatabaseUser)) {
            databaseTenant.stop(connection, this.systemDatabaseUser);
            databaseTenant.drop(connection, this.systemDatabaseUser);
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }
}

