/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseConfiguration;
import com.sap.hdb.sl.lib.instance.DatabaseConfigurationSection;
import com.sap.hdb.sl.lib.instance.DatabaseStatisticsServer;
import com.sap.hdb.sl.lib.instance.DatabaseSynonym;
import com.sap.hdb.sl.lib.instance.DatabaseTable;
import com.sap.hdb.sl.lib.instance.DatabaseXmlParameter;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.SchemaName;
import com.sap.hdb.sl.lib.instance.Sid;
import com.sap.hdb.sl.lib.instance.XmlParameters;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentFactory;
import com.sap.hdb.sl.lib.operating.system.HdbEnvironmentVariable;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.user.SystemDatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.AbapPreLoadExecution;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnableDistribution
implements CmdClazz {
    private Sid sapSid = null;
    private SchemaName schemaName = null;
    private SchemaName shadowSchemaName = null;
    private Database database = null;
    private Database systemDatabase = null;
    private DatabaseSystemUser systemUser = null;
    private DatabaseSystemUser systemDatabaseUser = null;
    private JdbcDriver jdbcDriver = null;
    private JdbcConnection connection = null;
    private XmlParameters xmlParameters;
    private DatabaseXmlParameter systemDbParameter = null;

    protected EnableDistribution() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.sapSid = new Sid(parameters.get(CmdClazzParameterName.SAP_SID).getValue());
        try {
            this.schemaName = new SchemaName(parameters.get(CmdClazzParameterName.SCHEMA_NAME).getValue());
            this.shadowSchemaName = new SchemaName(this.schemaName + "SHD");
        }
        catch (HdbException e) {
            this.schemaName = null;
            this.shadowSchemaName = null;
        }
        this.jdbcDriver = new JdbcDriver(parameters);
        if (parameters.containsKey(CmdClazzParameterName.XML_PARAMETERS)) {
            this.xmlParameters = (XmlParameters)parameters.get(CmdClazzParameterName.XML_PARAMETERS);
        } else if (parameters.containsKey(CmdClazzParameterName.XML_PARAMETER_FILE)) {
            this.xmlParameters = new XmlParameters(parameters);
        }
        if (parameters.containsKey(CmdClazzParameterName.SYSTEM_DATABASE_SYSTEM_USER_PASSWORD)) {
            this.systemDatabaseUser = SystemDatabaseSystemUserFactory.getUser(parameters);
            this.systemDatabase = InstanceFactory.getSystemDatabaseInstance(parameters);
        }
    }

    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.database);
        }
        this.setDefaultParameterValues();
        this.setParameterValues();
        this.createPublicTablePlacementSynonym();
    }

    private void createPublicTablePlacementSynonym() {
        DatabaseSynonym synonym = new DatabaseSynonym("TABLE_PLACEMENT");
        DatabaseTable table = new DatabaseTable("TABLE_PLACEMENT");
        table.setSchemaName("SYS");
        if (!synonym.exists(this.connection)) {
            if (table.exists(this.connection)) {
                synonym.create(this.connection, table);
            } else {
                table.setSchemaName("_SYS_RT");
                if (table.exists(this.connection)) {
                    synonym.create(this.connection, table);
                } else {
                    LogFactory.writeLogEntry(this.getClass(), "Table TABLE_PLACEMENT does not exist!");
                }
            }
        }
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
    }

    private void setDefaultParameterValues() {
        DatabaseConfiguration indexServerConfig = new DatabaseConfiguration(this.connection, this.systemUser, DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI);
        DatabaseConfigurationSection distributionSection = indexServerConfig.getSection("distribution");
        distributionSection.setParameter("client_distribution_mode", DatabaseXmlParameter.DEFAULT_PARAMETER_VALUES.get((Object)DatabaseConfiguration.ConfigFileName.INDEXSERVER_INI).get("distribution").get("client_distribution_mode"));
        DatabaseConfiguration globalConfig = new DatabaseConfiguration(this.connection, this.systemUser, DatabaseConfiguration.ConfigFileName.GLOBAL_INI);
        DatabaseConfigurationSection tablePlacementSection = globalConfig.getSection("table_placement");
        tablePlacementSection.setParameter("method", DatabaseXmlParameter.DEFAULT_PARAMETER_VALUES.get((Object)DatabaseConfiguration.ConfigFileName.GLOBAL_INI).get("table_placement").get("method"));
        String bwSchemaValue = tablePlacementSection.getParameterValue("bw_schema");
        if (this.schemaName == null) {
            bwSchemaValue = "SAP" + this.sapSid + ",SAP" + this.sapSid + "SHD";
        } else {
            if (bwSchemaValue == null) {
                bwSchemaValue = "";
            }
            if (!bwSchemaValue.contains(this.schemaName.getValue())) {
                if (bwSchemaValue.length() > 0) {
                    bwSchemaValue = bwSchemaValue + ",";
                }
                bwSchemaValue = bwSchemaValue + this.schemaName.getValue();
            }
            if (!bwSchemaValue.contains(this.shadowSchemaName.getValue())) {
                if (bwSchemaValue.length() > 0) {
                    bwSchemaValue = bwSchemaValue + ",";
                }
                bwSchemaValue = bwSchemaValue + this.shadowSchemaName.getValue();
            }
        }
        tablePlacementSection.setParameter("bw_schema", bwSchemaValue);
        tablePlacementSection.setParameter("prefix", DatabaseXmlParameter.DEFAULT_PARAMETER_VALUES.get((Object)DatabaseConfiguration.ConfigFileName.GLOBAL_INI).get("table_placement").get("prefix"));
        HdbEnvironmentVariable variable = HdbEnvironmentFactory.getVariable("HDB_IMPORT_STAISTICS_OFF");
        if (variable.isSet()) {
            LogFactory.writeLogEntry(this.getClass(), "Variable: " + variable.getName().get() + " is set with value: " + variable.getValue().get());
            DatabaseStatisticsServer statServer = new DatabaseStatisticsServer();
            statServer.setOff(this.connection, this.systemUser);
        }
    }

    private void setParameterValues() {
        if (this.xmlParameters == null) {
            return;
        }
        File parameterFile = new File(AbapPreLoadExecution.PARAMETER_FILE_NAME);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(parameterFile));
            NodeList parameterNodes = this.xmlParameters.getParameterXmlDocument().getElementsByTagName("Parameter");
            for (int i = 0; i < parameterNodes.getLength(); ++i) {
                DatabaseXmlParameter parameter;
                Node parameterNode = parameterNodes.item(i);
                try {
                    parameter = DatabaseXmlParameter.fromXml(parameterNode);
                }
                catch (HdbException e) {
                    LogFactory.writeLogEntry(this.getClass(), "Invalid parameter: " + e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    LogFactory.writeLogEntry(this.getClass(), "Invalid parameter: " + e.getMessage());
                    throw new HdbException(e);
                }
                if (DatabaseConfiguration.ConfigFileName.GLOBAL_INI == parameter.getConfigurationFileName() && "table_placement".equalsIgnoreCase(parameter.getSectionName()) && "bw_schema".equals(parameter.getParameterName())) {
                    LogFactory.writeLogEntry(DatabaseXmlParameter.class, "Illegal parameter. Parameter 'bw_schema' is set automatically and cannot be overwritten.");
                    continue;
                }
                if (this.connection.isMultiDB() && DatabaseConfiguration.ConfigFileName.GLOBAL_INI == parameter.getConfigurationFileName() && "memorymanager".equalsIgnoreCase(parameter.getSectionName()) && "global_allocation_limit".equals(parameter.getParameterName())) {
                    this.systemDbParameter = parameter;
                    continue;
                }
                DatabaseConfiguration databaseConfiguration = new DatabaseConfiguration(this.connection, this.systemUser, parameter.getConfigurationFileName());
                DatabaseConfigurationSection databaseConfigurationSection = databaseConfiguration.getSection(parameter.getSectionName());
                if (!parameter.isDefaultParameter() && !parameter.isPersistent()) {
                    String oldParameterValue = databaseConfigurationSection.getParameterValue(parameter.getParameterName());
                    bw.write(parameter.getConfigurationFileName().toString() + "|" + parameter.getSectionName().toString() + "|" + parameter.getParameterName() + "|" + oldParameterValue);
                    bw.newLine();
                }
                databaseConfigurationSection.setParameter(parameter.getParameterName(), parameter.getParameterValue());
            }
            if (null != this.systemDbParameter) {
                JdbcConnection systemDBconn = JdbcConnectionFactory.getInstance(this.jdbcDriver, this.systemDatabase);
                systemDBconn.setConnectUser(this.systemDatabaseUser);
                DatabaseConfiguration databaseConfiguration = new DatabaseConfiguration(systemDBconn, this.systemDatabaseUser, this.systemDbParameter.getConfigurationFileName());
                DatabaseConfigurationSection databaseConfigurationSection = databaseConfiguration.getSection(this.systemDbParameter.getSectionName());
                databaseConfigurationSection.setParameter(this.systemDbParameter.getParameterName(), this.systemDbParameter.getParameterValue());
            }
        }
        catch (IOException e) {
            LogFactory.writeLogEntry(this.getClass(), "Error writing database parameter values to file '" + parameterFile + "': " + e.getMessage());
            throw new HdbException(e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setJdbcConnection(JdbcConnection connection) {
        this.connection = connection;
    }
}

