/*
 * Decompiled with CFR 0.152.
 */
package com.sap.hdb.sl.lib.utils.cmd.clazz;

import com.sap.hdb.sl.lib.connection.sql.JdbcConnection;
import com.sap.hdb.sl.lib.connection.sql.JdbcConnectionFactory;
import com.sap.hdb.sl.lib.connection.sql.JdbcDriver;
import com.sap.hdb.sl.lib.exceptions.HdbException;
import com.sap.hdb.sl.lib.instance.Database;
import com.sap.hdb.sl.lib.instance.DatabaseReorg;
import com.sap.hdb.sl.lib.instance.FileParameter;
import com.sap.hdb.sl.lib.instance.HdbVersion;
import com.sap.hdb.sl.lib.instance.Hostname;
import com.sap.hdb.sl.lib.instance.InstanceFactory;
import com.sap.hdb.sl.lib.instance.IntegerParameter;
import com.sap.hdb.sl.lib.logging.LogFactory;
import com.sap.hdb.sl.lib.user.DatabaseSqlUser;
import com.sap.hdb.sl.lib.user.DatabaseSqlUserFactory;
import com.sap.hdb.sl.lib.user.DatabaseSystemUser;
import com.sap.hdb.sl.lib.user.DatabaseSystemUserFactory;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazz;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterMap;
import com.sap.hdb.sl.lib.utils.cmd.clazz.CmdClazzParameterName;
import com.sap.hdb.sl.lib.utils.cmd.clazz.ResultFileWriter;
import java.io.File;
import java.sql.Connection;
import java.util.Map;

public class ExecuteDatabaseReorg
implements CmdClazz {
    private ResultFileWriter resultFileWriter;
    private Database database;
    private DatabaseSystemUser systemUser;
    private JdbcDriver jdbcDriver;
    private JdbcConnection connection;
    private DatabaseSqlUser sqlUser;
    private File tableFile;
    private File tableClassificationFile;
    private long timeout = 36000L;
    private long tableClassificationTimeout = 90L;

    protected ExecuteDatabaseReorg() {
    }

    @Override
    public void setArguments(CmdClazzParameterMap parameters) {
        this.database = InstanceFactory.getDatabaseInstance(parameters);
        this.systemUser = DatabaseSystemUserFactory.getUser(parameters);
        this.jdbcDriver = new JdbcDriver(parameters);
        this.sqlUser = DatabaseSqlUserFactory.getUser(parameters);
        this.tableFile = parameters.get(CmdClazzParameterName.DATABASE_REORG_INPUT_FILE, FileParameter.class).getFile();
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_REORG_CLASSIFICATION_FILE)) {
            this.tableClassificationFile = parameters.get(CmdClazzParameterName.DATABASE_REORG_CLASSIFICATION_FILE, FileParameter.class).getFile();
        }
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_REORG_TIMEOUT)) {
            this.timeout = parameters.get(CmdClazzParameterName.DATABASE_REORG_TIMEOUT, IntegerParameter.class).getIntegerValue() * 60L;
        }
        if (parameters.containsKey(CmdClazzParameterName.DATABASE_REORG_CLASSIFICATION_TIMEOUT)) {
            this.tableClassificationTimeout = parameters.get(CmdClazzParameterName.DATABASE_REORG_CLASSIFICATION_TIMEOUT, IntegerParameter.class).getIntegerValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (null == this.connection) {
            this.connection = JdbcConnectionFactory.getInstanceNoReconnect(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.sqlUser);
        }
        if (!this.connection.isMultiDB()) {
            String masterHost = this.database.getMasterHost(this.connection, this.systemUser);
            String masterHostPublicName = this.database.getPublicNameForHost(this.connection, this.systemUser, masterHost);
            this.database.setHostname(new Hostname(masterHostPublicName));
            this.connection.closeConnection();
            this.connection = JdbcConnectionFactory.getInstanceNoReconnect(this.jdbcDriver, this.database);
            this.connection.setConnectUser(this.sqlUser);
        }
        Connection jdbcConnection = this.connection.getConnection();
        HdbVersion currentDatabaseVersion = new HdbVersion(JdbcConnectionFactory.getUniqueInstance(this.jdbcDriver, this.database), this.systemUser);
        DatabaseReorg reorg = new DatabaseReorg(this.sqlUser, currentDatabaseVersion);
        if (this.tableClassificationFile != null) {
            LogFactory.writeLogEntry(this.getClass(), "Adding table classifications from file " + this.tableClassificationFile.getAbsolutePath());
            try {
                reorg.addTableClassifications(this.jdbcDriver, this.database, this.tableClassificationFile, this.tableClassificationTimeout);
            }
            catch (HdbException e) {
                this.resultFileWriter.append(String.valueOf(false));
                this.resultFileWriter.append(e.getMessage());
                return;
            }
        }
        try {
            boolean nw740Format = this.tableClassificationFile != null;
            LogFactory.writeLogEntry(this.getClass(), "Filling table redistribution input table from file " + this.tableFile.getAbsolutePath());
            try {
                reorg.fillReorgTable(jdbcConnection, this.tableFile, nw740Format);
            }
            catch (HdbException e) {
                this.resultFileWriter.append(String.valueOf(false));
                this.resultFileWriter.append(e.getMessage());
                LogFactory.writeLogEntry(this.getClass(), "Dropping table redistribution input table.");
                try {
                    reorg.dropInputTable(jdbcConnection);
                }
                catch (HdbException e2) {
                    this.resultFileWriter.append(String.valueOf(true));
                    this.resultFileWriter.append("An error occurred while dropping the reorg input table " + reorg.getInputTableName() + ": " + e2.getMessage());
                    return;
                }
                return;
            }
            LogFactory.writeLogEntry(this.getClass(), "Generating table redistribution plan.");
            try {
                reorg.generatePlan(jdbcConnection);
            }
            catch (HdbException e) {
                this.resultFileWriter.append(String.valueOf(false));
                this.resultFileWriter.append(e.getMessage());
                LogFactory.writeLogEntry(this.getClass(), "Dropping table redistribution input table.");
                try {
                    reorg.dropInputTable(jdbcConnection);
                }
                catch (HdbException e3) {
                    this.resultFileWriter.append(String.valueOf(true));
                    this.resultFileWriter.append("An error occurred while dropping the reorg input table " + reorg.getInputTableName() + ": " + e3.getMessage());
                    return;
                }
                return;
            }
            LogFactory.writeLogEntry(this.getClass(), "Executing table redistribution plan.");
            int reorgId = 0;
            try {
                reorgId = reorg.executePlan(jdbcConnection);
            }
            catch (HdbException e) {
                this.resultFileWriter.append(String.valueOf(false));
                this.resultFileWriter.append(e.getMessage());
                LogFactory.writeLogEntry(this.getClass(), "Dropping table redistribution input table.");
                try {
                    reorg.dropInputTable(jdbcConnection);
                }
                catch (HdbException e4) {
                    this.resultFileWriter.append(String.valueOf(true));
                    this.resultFileWriter.append("An error occurred while dropping the reorg input table " + reorg.getInputTableName() + ": " + e4.getMessage());
                    return;
                }
                return;
            }
            LogFactory.writeLogEntry(this.getClass(), "Waiting for table redistribution completion.");
            try {
                reorg.waitForReorgCompletion(jdbcConnection, reorgId, this.timeout);
            }
            catch (HdbException e) {
                this.resultFileWriter.append(String.valueOf(false));
                this.resultFileWriter.append(e.getMessage());
                LogFactory.writeLogEntry(this.getClass(), "Dropping table redistribution input table.");
                try {
                    reorg.dropInputTable(jdbcConnection);
                }
                catch (HdbException e5) {
                    this.resultFileWriter.append(String.valueOf(true));
                    this.resultFileWriter.append("An error occurred while dropping the reorg input table " + reorg.getInputTableName() + ": " + e5.getMessage());
                    return;
                }
                return;
            }
            Map<String, String> failedTables = null;
            try {
                failedTables = reorg.getFailedTables(jdbcConnection, reorgId);
            }
            catch (HdbException e) {
                this.resultFileWriter.append(String.valueOf(false));
                this.resultFileWriter.append(e.getMessage());
                LogFactory.writeLogEntry(this.getClass(), "Dropping table redistribution input table.");
                try {
                    reorg.dropInputTable(jdbcConnection);
                }
                catch (HdbException e6) {
                    this.resultFileWriter.append(String.valueOf(true));
                    this.resultFileWriter.append("An error occurred while dropping the reorg input table " + reorg.getInputTableName() + ": " + e6.getMessage());
                    return;
                }
                return;
            }
            if (failedTables.size() > 0) {
                this.resultFileWriter.append(String.valueOf(false));
                this.resultFileWriter.append("The following tables were not reorganized successfully:");
                for (Map.Entry<String, String> entry : failedTables.entrySet()) {
                    this.resultFileWriter.append(entry.getKey() + " (Reason: " + entry.getValue() + ")");
                }
            }
        }
        finally {
            LogFactory.writeLogEntry(this.getClass(), "Dropping table redistribution input table.");
            try {
                reorg.dropInputTable(jdbcConnection);
            }
            catch (HdbException e) {
                this.resultFileWriter.append(String.valueOf(true));
                this.resultFileWriter.append("An error occurred while dropping the reorg input table " + reorg.getInputTableName() + ": " + e.getMessage());
                return;
            }
        }
        this.resultFileWriter.append(String.valueOf(true));
    }

    @Override
    public void setResultFileWriter(ResultFileWriter writer) {
        this.resultFileWriter = writer;
    }
}

